% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/continue.R, R/abc.R, R/pmcmc.R, R/mif2.R
\docType{methods}
\name{continue}
\alias{continue}
\alias{continue,missing-method}
\alias{continue,ANY-method}
\alias{continue-abcd_pomp}
\alias{continue,abcd_pomp-method}
\alias{continue-pmcmcd_pomp}
\alias{continue,pmcmcd_pomp-method}
\alias{continue-mif2d_pomp}
\alias{continue,mif2d_pomp-method}
\title{Continue an iterative calculation}
\usage{
continue(object, ...)

\S4method{continue}{abcd_pomp}(object, Nabc = 1, ...)

\S4method{continue}{pmcmcd_pomp}(object, Nmcmc = 1, ...)

\S4method{continue}{mif2d_pomp}(object, Nmif = 1, ...)
}
\arguments{
\item{object}{the result of an iterative \pkg{pomp} computation}

\item{\dots}{additional arguments will be passed to the underlying method.
This allows one to modify parameters used in the original computations.}

\item{Nabc}{positive integer; number of additional ABC iterations to perform}

\item{Nmcmc}{positive integer; number of additional PMCMC iterations to perform}

\item{Nmif}{positive integer; number of additional filtering iterations to perform}
}
\description{
Continue an iterative computation where it left off.
}
\seealso{
\code{\link{mif2}} \code{\link{pmcmc}} \code{\link{abc}}
}
