library(pomp)

data(ou2)

set.seed(64857673L)

fit1.pfilter <- pfilter(ou2,Np=1000)
cat("coefficients at `truth'\n")
print(coef(ou2,c('x1.0','x2.0','alpha.1','alpha.4')),digits=4)
cat("particle filter log likelihood at truth\n")
print(fit1.pfilter$loglik,digits=4)

p.truth <- coef(ou2)
guess2 <- guess1 <- p.truth
guess1[c('x1.0','x2.0','alpha.1','alpha.4')] <- c(45,-60,0.8,0.9)
guess2[c('x1.0','x2.0','alpha.1','alpha.4')] <- c(60,-45,0.9,0.8)

mif1 <- mif(ou2,Nmif=10,start=guess1,
            pars=c('alpha.1','alpha.4'),ivps=c('x1.0','x2.0'),
            rw.sd=c(
              x1.0=5,x2.0=5,
              alpha.1=0.1,alpha.4=0.1
              ),
            Np=1000,
            var.factor=1,
            ic.lag=10,
            cooling.factor=0.95,
            max.fail=100
            )

mif2 <- mif(ou2,Nmif=10,start=guess2,
            pars=c('alpha.1','alpha.4'),ivps=c('x1.0','x2.0'),
            rw.sd=c(
              x1.0=5,x2.0=5,
              alpha.1=0.1,alpha.4=0.1
              ),
            Np=1000,
            var.factor=1,
            ic.lag=10,
            cooling.factor=0.95,
            max.fail=100
            )

pdf(file="ou2-mif.pdf")
plot(mif1)
compare.mif(mif2)
try(compare.mif(mif1,mif2))
compare.mif(list(mif1,mif2))
dev.off()

set.seed(33848585L)

try(
    mif(
        ou2,
        Nmif=1,
        pars=c("alpha.1","alpha.4","x1.0"),
        ivps=c("x1.0","x2.0"),
        rw.sd=c(x1.0=5,x2.0=5,alpha.1=0.1,alpha.4=0.2,alpha.3=0),
        Np=100,cooling.factor=0.95,ic.lag=10,var.factor=1
        )
    )

try(
    mif(
        ou2,
        Nmif=1,
        pars=c("alpha.1","alpha.4"),
        ivps=c("x1.0","x2.0"),
        rw.sd=c(x1.0=5,x2.0=5,alpha.1=0,alpha.4=0.2,alpha.3=0),
        Np=100,cooling.factor=0.95,ic.lag=10,var.factor=1
        )
    )

try(
    mif(
        ou2,
        Nmif=1,
        ivps=c("x1.0","x2.0"),
        rw.sd=c(alpha.1=0.1,alpha.4=0.2,alpha.3=0),
        Np=100,cooling.factor=0.95,ic.lag=10,var.factor=1
        )
    )

try(
    mif(
        ou2,
        Nmif=1,
        ivps=c("x1.0","x2.0"),
        rw.sd=c(x1.0=5,x2.0=5,alpha.1=0.1,alpha.4=0.2,alpha.3=0),
        Np=100,ic.lag=10,var.factor=1
        )
    )

try(
    mif(
        ou2,
        Nmif=1,
        ivps=c("x1.0","x2.0"),
        rw.sd=c(x1.0=5,x2.0=5,alpha.1=0,alpha.4=0.2,alpha.3=0),
        Np=-10,cooling.factor=0.95,ic.lag=10,var.factor=1
        )
    )

try(
    mif(
        ou2,
        Nmif=-3,
        ivps=c("x1.0","x2.0"),
        rw.sd=c(x1.0=5,x2.0=5,alpha.1=0,alpha.4=0.2,alpha.3=0),
        Np=11.6,cooling.factor=0.95,ic.lag=10,var.factor=1
        )
    )

fit <- mif(
           ou2,
           Nmif=0,
           pars=c("alpha.1","alpha.4"),
           ivps=c("x1.0","x2.0"),
           rw.sd=c(x1.0=5,x2.0=5,alpha.1=0.1,alpha.4=0.2,alpha.3=0),
           Np=100,cooling.factor=0.95,ic.lag=10,var.factor=1
           )
fit <- mif(
           fit,
           Nmif=2,
           ivps=c("x1.0","x2.0"),
           rw.sd=c(x1.0=5,x2.0=5,alpha.1=0.1,alpha.4=0.2),
           Np=1000,cooling.factor=0.95,ic.lag=10,var.factor=1
           )
fit <- continue(fit)
fit <- continue(fit,Nmif=2)
ff <- pfilter(fit,pred.mean=T,filter.mean=T,pred.var=T,max.fail=100)
fit <- mif(fit,rw.sd=c(x1.0=5,x2.0=5,alpha.1=0.1,alpha.4=0.1))
fit <- continue(fit,Nmif=2,ivps=c("x1.0"),pars=c("alpha.1"))
s <- coef(fit)
s[2] <- 0.01
fit <- mif(fit,Nmif=3,start=s)
fit <- mif(ou2,Nmif=3,rw.sd=c(alpha.1=0.1,alpha.4=0.1),Np=1000,cooling.factor=0.98,var.factor=1,ic.lag=2)
fit <- continue(fit,Nmif=2,Np=2000)
fit <- continue(fit,ivps=c("x1.0"),rw.sd=c(alpha.1=0.1,alpha.4=0.1,x1.0=5,x2.0=5),Nmif=2)
