% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filterPLSR}
\alias{filterPLSR}
\title{Optimisation of filters for Partial Least Squares}
\usage{
filterPLSR(y, X, ncomp = 10, ncomp.opt = c("minimum", "same"),
  validation = "LOO", LW.threshold = NULL, RC.threshold = NULL,
  JT.threshold = NULL, VIP.threshold = NULL, SR.threshold = NULL,
  sMC.threshold = NULL, ...)
}
\arguments{
\item{y}{vector of response values (\code{numeric} or \code{factor}).}

\item{X}{numeric predictor \code{matrix}.}

\item{ncomp}{integer number of components (default = 10).}

\item{ncomp.opt}{use the number of components corresponding to minimum error (minimum)
or \code{ncomp} (same).}

\item{validation}{type of validation in the PLS modelling (default = "LOO").}

\item{LW.threshold}{threshold for Loading Weights if applied (default = NULL).}

\item{RC.threshold}{threshold for Regression Coefficients if applied (default = NULL).}

\item{JT.threshold}{threshold for Jackknife Testing if applied (default = NULL).}

\item{VIP.threshold}{threshold for Variable Importance on Projections if applied (default = NULL).}

\item{SR.threshold}{threshold for Selectivity Ration if applied (default = NULL).}

\item{sMC.threshold}{threshold for Significance Multivariate Correlation if applied (default = NULL).}

\item{...}{additional paramters for \code{pls}, e.g. segmentation or similar.}
}
\value{
Returns a list of lists containing filters (outer list), their selected variables,
optimal numbers of components and prediction accuracies.
}
\description{
Extract the index of influential variables based on threshold defiend for
LW (loading weights), RC (regression coef), JT (jackknife testing) and VIP (variable 
importance on projection).
}
\details{
Filter methods are applied for variable selection with PLSR. This function can 
return selected variables and Root Mean Squared Error of Cross-Validation for various 
filter methods and determine optimum numbers of components.
}
\examples{
data(gasoline, package = "pls")
\dontrun{
with( gasoline, filterPLSR(octane, NIR, ncomp = 10, "minimum", validation = "LOO",
 RC.threshold = c(0.1,0.5), SR.threshold = 0.5))
}

}
\author{
Tahir Mehmood, Kristian Hovde Liland, Solve Sæbø.
}
\references{
T. Mehmood, K.H. Liland, L. Snipen, S. Sæbø, A review of variable selection 
methods in Partial Least Squares Regression, Chemometrics and Intelligent Laboratory Systems
118 (2012) 62-69.
}
\seealso{
\code{\link{VIP}} (SR/sMC/LW/RC), \code{\link{filterPLSR}}, \code{\link{spa_pls}}, 
\code{\link{stpls}}, \code{\link{truncation}}, \code{\link{bve_pls}}, \code{\link{mcuve_pls}},
\code{\link{ipw_pls}}, \code{\link{ga_pls}}, \code{\link{rep_pls}}.
}

