% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_or.R
\name{check_or}
\alias{check_or}
\title{Check OR}
\usage{
check_or(glm_model_results, confint_fast_estimate = FALSE, details = TRUE)
}
\arguments{
\item{glm_model_results}{Results from a binomial Generalised Linear Model (GLM), as produced by \code{\link[stats:glm]{stats::glm()}}.}

\item{confint_fast_estimate}{Boolean (default = \code{FALSE}) Use a faster estimate of the confidence interval? Note: this assumes normally distributed data, which may not be suitable for your data.}

\item{details}{Boolean (default = \code{TRUE}) Show detailed feedback for any failed tests?}
}
\value{
Logical, \code{TRUE} if all assumption tests pass, \code{FALSE} if one or more tests fail
}
\description{
Performs a series of tests to ensure that assumptions for logistic regression
are met, with optional detailed feedback if any tests fail.
}
\examples{
# Load the Titanic dataset
df <- datasets::Titanic |>
  dplyr::as_tibble() |>
  # convert aggregated counts to individual observations
  dplyr::filter(n > 0) |>
  tidyr::uncount(weights = n) |>
  # convert character variables to factors
  dplyr::mutate(dplyr::across(dplyr::where(is.character), as.factor))

# Perform logistic regression using `glm`
lr <- stats::glm(
  data = df,
  family = binomial,
  formula = Survived ~ Class + Sex + Age
)

# Check the model for logistic regression assumption violations
check_or(lr)
}
