% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{orderBoxplot}
\alias{orderBoxplot}
\title{Order boxplot stats following a given ordering.}
\usage{
orderBoxplot(stats, idx)
}
\arguments{
\item{stats}{List with information produced by a box-and-whisker plot.}

\item{idx}{Order of group levels.}
}
\value{
The ordered stats.
}
\description{
Order boxplot stats following a given ordering.
}
\examples{
head(ToothGrowth)
# sort on basis of mean length:
bp <- boxplot(len ~ dose:supp, data = ToothGrowth, plot=FALSE)
idx <- sortGroups(len ~ dose:supp, data = ToothGrowth)
bp2 <- orderBoxplot(bp, idx)
# compare:
bp$names
bp2$names
}
\seealso{
Other Utility functions: \code{\link{findAbsMin}},
  \code{\link{find_n_neighbors}},
  \code{\link{firstLetterCap}}, \code{\link{getArrowPos}},
  \code{\link{getDec}}, \code{\link{getRange}},
  \code{\link{getRatioCoords}}, \code{\link{group_sort}},
  \code{\link{inch2coords}}, \code{\link{isColor}},
  \code{\link{list2str}}, \code{\link{move_n_point}},
  \code{\link{se}}, \code{\link{sortGroups}}
}
\author{
Jacolien van Rij
}
