% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/medley.R
\name{medley}
\alias{medley}
\alias{medley_bw}
\alias{medley_model}
\title{Sprinkle Medleys}
\usage{
medley_bw(x)

medley_model(x, round = 2)
}
\arguments{
\item{x}{a \code{dust} object.}

\item{round}{A numerical value passed to the \code{round} sprinkle.}
}
\description{
\code{pixiedust} can get to be pretty verbose if you are doing
  a great deal of customization.  Sprinkle medleys can take out some of that
  code by bundling much of the formatting sprinkling into a single function.
  
  \code{pixiedust} comes with a couple very basic medleys that are mostly 
  for illustration of how to write medleys.  Once you get the hang of 
  sprinkling, you need only bundle your most common sprinkles into a 
  medley function of your own and cut down on some of the time 
  coding your most basic formatting.
}
\examples{
\dontrun{
fit <- lm(mpg ~ qsec + factor(am) + wt * factor(gear), data = mtcars)

dust(fit) \%>\%
  medley_bw() \%>\%
  sprinkle_print_method("html")
  
dust(fit, glance_foot = TRUE) \%>\%
  medley_model() \%>\%
  sprinkle_print_method("html")
  
# Medleys are not generics and do not have methods.
# Using a medley on a dust_list object requires pixieply

library(dplyr)
mtcars \%>\% 
  group_by(gear) \%>\% 
  dust(ungroup = FALSE) \%>\% 
  pixieply(medley_bw) \%>\% 
  sprinkle_print_method("html")
}

}
\author{
Benjamin Nutter
}
