% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sprinkle_longtable.R
\name{sprinkle_longtable}
\alias{sprinkle_longtable}
\alias{sprinkle_longtable.default}
\alias{sprinkle_longtable.dust_list}
\title{Change the Longtable Property in a Dust Table}
\usage{
sprinkle_longtable(x, longtable = getOption("pixie_longtable", FALSE), ...)

\method{sprinkle_longtable}{default}(x,
  longtable = getOption("pixie_longtable", FALSE), ...)

\method{sprinkle_longtable}{dust_list}(x,
  longtable = getOption("pixie_longtable", FALSE), ...)
}
\arguments{
\item{x}{An object of class \code{dust}}

\item{longtable}{Either a \code{logical(1)} or an \code{numeric(1)} 
integer-like value.  See Details.}

\item{...}{Additional arguments to pass to other methods. Currently ignored.}
}
\description{
The LaTeX \code{longtable} package allows for long tables
to be broken into multiple parts to be displayed on separate pages. 
\code{pixiedust} will mimic this behavior for other output types.
}
\details{
When \code{longtable = TRUE}, LaTeX tables will be divided 
  according to the LaTeX document settings.  In other table outputs, the 
  default is to use 25 rows per table.
  
  When \code{longtable} is an integer (or integer-like) value, the table 
  is divided into that many rows per section. This applies to all output.
}
\section{Functional Requirements}{

\enumerate{
 \item Change the \code{longtable} attribute of the \code{dust} object.
 \item Cast an error if \code{x} is not a \code{dust} object.
 \item Cast an error if \code{longtable} is logical and has length not equal 
   to 1.
 \item when \code{longtable} is not logical, cast an error if 
   it is not-integerish and has length not equal to 1.
}
}
\author{
Benjamin Nutter
}
\seealso{
\code{\link{dust}}, \code{\link{sprinkle}}
}

