% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndvi.r
\name{NDVI}
\alias{NDVI}
\title{Normalized Vegetation Index}
\usage{
NDVI(spct, imager = "LandsatOLI", wb.trim = FALSE)
}
\arguments{
\item{spct}{reflectance_spct or reflectance_mspct object.}

\item{imager}{character Name of the imager or standard to be used.}

\item{wb.trim}{logical Flag telling if wavebands crossing spectral data
boundaries are trimmed or ignored.}
}
\value{
A numeric vector.  When the wavelength range of \code{spct} does not
  fully overlap with both wavebands \code{NA} is silently returned.
}
\description{
Compute the NDVI from spectral reflectance according to waveband definitions
from standards or corresponding to satellite imagers.
}
\details{
NDVI is used in remote sensing to the diagnose the condition of
  vegetation, including crops. It is used for Landsat imagery but also at
  the farm or plot scale using cameras on drones. It is computed as:

  NDVI = (NIR - Red) / (NIR + Red)

  The waveband ranges used to compute reflectance vary. Even the imagers
  in the different Landsat satellites 1 to 8 have had somehow different
  wavelength sensitivities. The \code{NDVI()} function uses the waveband
  constructors \code{\link{Red}} and \code{\link{NIR}} defined in this
  package. Reflectance is averaged over the wavebands using function
  \code{\link[photobiology]{reflectance}}.
}
\note{
The value passed as argument to \code{imager} must be a valid argument
  for both \code{\link{Red}} and \code{\link{NIR}}. If the desired return
  value is a data frame, function \code{\link[photobiology]{NDxI}} can be
  used to flexibly compute NDVI and any similar index.
}
