% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.metadata.r
\name{trimInstrSettings}
\alias{trimInstrSettings}
\title{Trim the "instr.settings" attribute}
\usage{
trimInstrSettings(x, fields = "*")
}
\arguments{
\item{x}{a \code{generic_spct} object or a \code{summary_generic_spct}
object.}

\item{fields}{a character vector with the names of the fields to keep, or if
first member is \code{"-"}, the names of fields to delete; \code{"*"} as
first member of the vector makes the function a no-op, leaving the spectrum
object unaltered.}
}
\value{
\code{x}, possibly with the \code{"instr.settings"} attribute
  modified.
}
\description{
Trim the \code{"instr.settings"} attribute of an existing \code{generic_spct}
object or of a \code{summary_generic_spct} object, by discarding some fields.
}
\details{
This function alters \code{x} itself by reference and in addition
  returns \code{x} invisibly. If \code{x} is not a \code{generic_spct} object
  or a \code{summary_generic_spct} object, or if the \code{"instr.settings"}
  attribute is not present in \code{x}, \code{x} is not modified.

  Attempts to remove or keep fields that are not present in the attribute are
  ignored silently. The value of fields in the attribute is never modified,
  fields are either kept unchanged or removed.
}
\examples{

my.spct <- white_led.cps_spct
names(instr_settings(my.spct))
trimInstrSettings(my.spct, fields = c("-", "pix.selector")) # by reference!
names(instr_settings(my.spct))

}
\seealso{
Other measurement metadata functions: 
\code{\link{add_attr2tb}()},
\code{\link{getFilterProperties}()},
\code{\link{getHowMeasured}()},
\code{\link{getInstrDesc}()},
\code{\link{getInstrSettings}()},
\code{\link{getSoluteProperties}()},
\code{\link{getWhatMeasured}()},
\code{\link{getWhenMeasured}()},
\code{\link{getWhereMeasured}()},
\code{\link{get_attributes}()},
\code{\link{isValidInstrDesc}()},
\code{\link{isValidInstrSettings}()},
\code{\link{select_spct_attributes}()},
\code{\link{setFilterProperties}()},
\code{\link{setHowMeasured}()},
\code{\link{setInstrDesc}()},
\code{\link{setInstrSettings}()},
\code{\link{setSoluteProperties}()},
\code{\link{setWhatMeasured}()},
\code{\link{setWhenMeasured}()},
\code{\link{setWhereMeasured}()},
\code{\link{spct_attr2tb}()},
\code{\link{spct_metadata}()},
\code{\link{subset_attributes}()},
\code{\link{trimInstrDesc}()}
}
\concept{measurement metadata functions}
