% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/insert.hinges.r
\name{insert_hinges}
\alias{insert_hinges}
\title{Insert wavelength values into spectral data.}
\usage{
insert_hinges(x, y, h)
}
\arguments{
\item{x}{numeric vector (sorted in increasing order)}

\item{y}{numeric vector}

\item{h}{a numeric vector giving the wavelengths at which the y values
should be inserted by interpolation, no interpolation is indicated by an
empty vector (numeric(0))}
}
\value{
a data.frame with variables \code{x} and \code{y}. Unless the hinge
  values were already present in \code{y}, each inserted hinge, expands the
  vectors returned in the data frame by one value.
}
\description{
Inserting wavelengths values immediately before and after a discontinuity in
the SWF, greatly reduces the errors caused by interpolating the weighted
irradiance during integration of the effective spectral irradiance. This is
specially true when data have a large wavelength step size.
}
\note{
Insertion is a costly operation but I have tried to optimize this
function as much as possible by avoiding loops. Earlier this function was
implemented in C++, but a bug was discovered and I have now rewritten it
using R.
}
\examples{
with(sun.data,
    insert_hinges(w.length, s.e.irrad,
       c(399.99, 400.00, 699.99, 700.00)))

}
\seealso{
Other low-level functions operating on numeric vectors.: 
\code{\link{as_energy}()},
\code{\link{as_quantum_mol}()},
\code{\link{calc_multipliers}()},
\code{\link{div_spectra}()},
\code{\link{energy_irradiance}()},
\code{\link{energy_ratio}()},
\code{\link{integrate_xy}()},
\code{\link{interpolate_spectrum}()},
\code{\link{irradiance}()},
\code{\link{l_insert_hinges}()},
\code{\link{oper_spectra}()},
\code{\link{photon_irradiance}()},
\code{\link{photon_ratio}()},
\code{\link{photons_energy_ratio}()},
\code{\link{prod_spectra}()},
\code{\link{s_e_irrad2rgb}()},
\code{\link{split_energy_irradiance}()},
\code{\link{split_photon_irradiance}()},
\code{\link{subt_spectra}()},
\code{\link{sum_spectra}()},
\code{\link{trim_tails}()},
\code{\link{v_insert_hinges}()},
\code{\link{v_replace_hinges}()}
}
\concept{low-level functions operating on numeric vectors.}
