% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.absorbance.R
\name{absorbance}
\alias{absorbance}
\alias{absorbance.default}
\alias{absorbance.filter_spct}
\alias{absorbance.object_spct}
\alias{absorbance.filter_mspct}
\alias{absorbance.object_mspct}
\title{Absorbance}
\usage{
absorbance(spct, w.band, quantity, wb.trim, use.hinges, ...)

\method{absorbance}{default}(spct, w.band, quantity, wb.trim, use.hinges, ...)

\method{absorbance}{filter_spct}(
  spct,
  w.band = NULL,
  quantity = "average",
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.hinges = NULL,
  naming = "default",
  ...
)

\method{absorbance}{object_spct}(
  spct,
  w.band = NULL,
  quantity = "average",
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.hinges = NULL,
  naming = "default",
  ...
)

\method{absorbance}{filter_mspct}(
  spct,
  w.band = NULL,
  quantity = "average",
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.hinges = NULL,
  naming = "default",
  ...,
  attr2tb = NULL,
  idx = "spct.idx",
  .parallel = FALSE,
  .paropts = NULL
)

\method{absorbance}{object_mspct}(
  spct,
  w.band = NULL,
  quantity = "average",
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.hinges = NULL,
  naming = "default",
  ...,
  attr2tb = NULL,
  idx = "spct.idx",
  .parallel = FALSE,
  .paropts = NULL
)
}
\arguments{
\item{spct}{an R object.}

\item{w.band}{waveband or list of waveband objects or a numeric vector of
length two. The waveband(s) determine the region(s) of the spectrum that
are summarized. If a numeric range is supplied a waveband object is
constructed on the fly from it.}

\item{quantity}{character string One of \code{"average"} or \code{"mean"},
\code{"total"}, \code{"contribution"}, \code{"contribution.pc"},
\code{"relative"} or \code{"relative.pc"}.}

\item{wb.trim}{logical if \code{TRUE} wavebands crossing spectral data
boundaries are trimmed, if \code{FALSE}, they are discarded.}

\item{use.hinges}{logical Flag indicating whether to insert "hinges" into the
spectral data before integration so as to reduce interpolation errors at
the boundaries of the wavebands.}

\item{...}{other arguments (possibly used by derived methods).}

\item{naming}{character one of \code{"long"}, \code{"default"},
\code{"short"} or \code{"none"}. Used to select the type of names to assign
to returned value.}

\item{attr2tb}{character vector, see \code{\link{add_attr2tb}} for the syntax for \code{attr2tb} passed as is to formal parameter \code{col.names}.}

\item{idx}{character Name of the column with the names of the members of the
collection of spectra.}

\item{.parallel}{if TRUE, apply function in parallel, using parallel backend
provided by foreach}

\item{.paropts}{a list of additional options passed into the foreach function
when parallel computation is enabled. This is important if (for example)
your code relies on external data or packages: use the .export and
.packages arguments to supply them so that all cluster nodes have the
correct environment set up for computing.}
}
\value{
A named \code{numeric} vector in the case of methods for individual
  spectra, with one value for each \code{waveband} passed to parameter
  \code{w.band}. A \code{data.frame} in the case of collections of spectra,
  containing one column for each \code{waveband} object, an index column with
  the names of the spectra, and optionally additional columns with metadata
  values retrieved from the attributes of the member spectra.

  By default values are only integrated, but depending on the argument passed
  to parameter \code{quantity} they can be re-expressed as relative fractions
  or percentages. In the case of vector output, \code{names} attribute is set
  to the name of the corresponding waveband unless a named list is supplied
  in which case the names of the list members are used.
}
\description{
Function to calculate the mean, total, or other summary of absorbance for
spectral data stored in a \code{filter_spct} or in an \code{object_spct}.
}
\section{Methods (by class)}{
\itemize{
\item \code{absorbance(default)}: Default for generic function

\item \code{absorbance(filter_spct)}: Specialization for filter spectra

\item \code{absorbance(object_spct)}: Specialization for object spectra

\item \code{absorbance(filter_mspct)}: Calculates absorbance from a \code{filter_mspct}

\item \code{absorbance(object_mspct)}: Calculates absorbance from a \code{object_mspct}

}}
\note{
The \code{use.hinges} parameter controls speed optimization. The
  defaults should be suitable in most cases. Only the range of wavelengths in
  the wavebands is used and all BSWFs are ignored.
}
\examples{
absorbance(polyester.spct, new_waveband(400,700))
absorbance(yellow_gel.spct, new_waveband(400,700))
absorbance(yellow_gel.spct, split_bands(c(400,700), length.out = 3))
absorbance(yellow_gel.spct, split_bands(c(400,700), length.out = 3),
        quantity = "average")
absorbance(yellow_gel.spct, split_bands(c(400,700), length.out = 3),
        quantity = "total")
absorbance(yellow_gel.spct, split_bands(c(400,700), length.out = 3),
        quantity = "relative")
absorbance(yellow_gel.spct, split_bands(c(400,700), length.out = 3),
        quantity = "relative.pc")
absorbance(yellow_gel.spct, split_bands(c(400,700), length.out = 3),
        quantity = "contribution")
absorbance(yellow_gel.spct, split_bands(c(400,700), length.out = 3),
        quantity = "contribution.pc")

}
