% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.operators.r
\name{e2q}
\alias{e2q}
\alias{e2q.default}
\alias{e2q.source_spct}
\alias{e2q.response_spct}
\alias{e2q.source_mspct}
\alias{e2q.response_mspct}
\title{Convert energy-based quantities into photon-based quantities.}
\usage{
e2q(x, action, byref, ...)

\method{e2q}{default}(x, action = "add", byref = FALSE, ...)

\method{e2q}{source_spct}(x, action = "add", byref = FALSE, ...)

\method{e2q}{response_spct}(x, action = "add", byref = FALSE, ...)

\method{e2q}{source_mspct}(x, action = "add", byref = FALSE, ..., .parallel = FALSE, .paropts = NULL)

\method{e2q}{response_mspct}(x, action = "add", byref = FALSE, ..., .parallel = FALSE, .paropts = NULL)
}
\arguments{
\item{x}{an R object}

\item{action}{a character string}

\item{byref}{logical indicating if new object will be created by reference or by copy of x}

\item{...}{not used in current version}

\item{.parallel}{if TRUE, apply function in parallel, using parallel backend
provided by foreach}

\item{.paropts}{a list of additional options passed into the foreach function
when parallel computation is enabled. This is important if (for example)
your code relies on external data or packages: use the .export and
.packages arguments to supply them so that all cluster nodes have the
correct environment set up for computing.}
}
\description{
Function that converts spectral energy irradiance into spectral photon irradiance (molar).
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method

\item \code{source_spct}: Method for spectral irradiance

\item \code{response_spct}: Method for spectral responsiveness

\item \code{source_mspct}: Method for collections of (light) source spectra

\item \code{response_mspct}: Method for collections of response spectra
}}

\seealso{
Other quantity conversion functions: 
\code{\link{A2T}()},
\code{\link{Afr2T}()},
\code{\link{T2Afr}()},
\code{\link{T2A}()},
\code{\link{any2T}()},
\code{\link{as_quantum}()},
\code{\link{e2qmol_multipliers}()},
\code{\link{e2quantum_multipliers}()},
\code{\link{q2e}()}
}
\concept{quantity conversion functions}
