% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ph_prep.R
\name{ph_prep}
\alias{ph_prep}
\title{Preprocessing for phenotype classification via ensemble learning.}
\usage{
ph_prep(
  df,
  ids_col,
  class_col,
  vali_pct = 0.15,
  test_pct = 0.15,
  scale = FALSE,
  center = NULL,
  sd = NULL,
  split_seed = 123,
  method = "pca",
  pca_pct = 0.95,
  max_mem_size = "15g",
  port = 54321,
  train_seed = 123,
  hyper_params = list(),
  search = "random",
  tune_length = 100
)
}
\arguments{
\item{df}{A \code{data.frame} containing a column of unique ids, a column of classes, and an arbitrary number of \code{numeric} columns.}

\item{ids_col}{A \code{character} value for the name of the ids column.}

\item{class_col}{A \code{character} value for the name of the class column.}

\item{vali_pct}{A \code{numeric} value for the percentage of training data to use as validation data: 0.15 (default).}

\item{test_pct}{A \code{numeric} value for the percentage of total data to use as test data: 0.15 (default).}

\item{scale}{A \code{logical} value for whether to scale the data: FALSE (default). Recommended if \code{method = "ae"} and if user intends to train other models.}

\item{center}{Either a \code{logical} value or numeric-alike vector of length equal to the number of columns of data to scale in \code{df}, where ‘numeric-alike’ means that as.numeric(.) will be applied successfully if is.numeric(.) is not true: NULL (default). If \code{scale = TRUE}, this is set to \code{TRUE} and is used to subtract the mean.}

\item{sd}{Either a \code{logical} value or a numeric-alike vector of length equal to the number of columns of data to scale in \code{df}: NULL (default). If \code{scale = TRUE}, this is set to \code{TRUE} and is used to divide by the standard deviation.}

\item{split_seed}{A \code{numeric} value to set the seed and control the randomness of splitting the data: 123 (default).}

\item{method}{A \code{character} value for the dimensionality reduction method: "pca" (default), "ae", "none".}

\item{pca_pct}{If \code{method = "pca"}, a \code{numeric} value for the proportion of variance to subset the PCA with: 0.95 (default).}

\item{max_mem_size}{If \code{method = "ae"}, a \code{character} value for the memory of an h2o session: "15g" (default).}

\item{port}{A \code{numeric} value for the port number of the H2O server.}

\item{train_seed}{A \code{numeric} value to set the control the randomness of creating resamples: 123 (default).}

\item{hyper_params}{A \code{list} of hyperparameters to perform a grid search. the "default" list is: list(missing_values_handling = "Skip", activation = c("Rectifier", "Tanh"), hidden = list(5, 25, 50, 100, 250, 500, nrow(df_h2o)), input_dropout_ratio = c(0, 0.1, 0.2, 0.3), rate = c(0, 0.01, 0.005, 0.001)).}

\item{search}{If \code{method = "ae"}, a \code{character} value for the hyperparameter search strategy: "random" (default), "grid".}

\item{tune_length}{If \code{method = "ae"}, a \code{numeric} value (integer) for either the maximum number of hyperparameter combinations ("random") or individual hyperparameter depth ("grid").}
}
\value{
A list containing the following components:\tabular{ll}{
\code{train_df} \tab The training set data frame. \cr
\tab \cr
\code{vali_df} \tab The validation set data frame. \cr
\tab \cr
\code{test_df} \tab The test set data frame. \cr
\tab \cr
\code{train_split} \tab The training set indices from the original data frame. \cr
\tab \cr
\code{vali_split} \tab The validation set indices from the original data frame. \cr
\tab \cr
\code{test_split} \tab The test set indices from the original data frame. \cr
\tab \cr
\code{vali_pct} \tab The percentage of training data used as validation data. \cr
\tab \cr
\code{test_pct} \tab The percentage of total data used as test data. \cr
\tab \cr
\code{method} \tab The dimensionality reduction method. \cr
}
}
\description{
The \code{ph_prep} function splits a data frame into training, validation, and test sets, all while ensuring that
every class is represented in each dataset. By default, it performs a Principal Component Analysis on the training
set data and projects the validation and test data into that space. If a non-linear dimensionality reduction
strategy is preferred instead, an autoencoder can be used to extract deep features. Note that the parameters
\code{max_mem_size}, \code{activation}, \code{hidden}, \code{dropout_ratio}, \code{rate}, \code{search}, and
\code{tune_length} are \code{NULL} unless an autoencoder, \code{method = "ae"}, is used. In this case,
lists or vectors can be supplied to these parameters (see parameter details) to perform a grid search for the
optimal hyperparameter combination. The autoencoder with the lowest reconstruction error is selected as
the best model.
}
\examples{
## Import data.
data(ph_crocs)
\donttest{
## Remove anomalies with autoencoder.
rm_outs <- ph_anomaly(df = ph_crocs, ids_col = "Biosample",
                      class_col = "Species", method = "ae")
## Preprocess anomaly-free data frame into train, validation, and test sets
## with PCs as predictors.
pc_dfs <- ph_prep(df = rm_outs$df, ids_col = "Biosample",
                  class_col = "Species", vali_pct = 0.15,
                  test_pct = 0.15, method = "pca")
## Alternatively, preprocess data frame into train, validation, and test
## sets with latent variables as predictors. Notice that port is defined,
## because running H2O sessions one after another can cause connection
## errors.
ae_dfs <- ph_prep(df = rm_outs$df, ids_col = "Biosample", class_col = "Species",
                  vali_pct = 0.15, test_pct = 0.15, method = "ae", port = 50001)
}
}
