% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ph_ctrl.R
\name{ph_ctrl}
\alias{ph_ctrl}
\title{Parameters for resampling and training a dataset.}
\usage{
ph_ctrl(
  class,
  resample_method = "boot",
  number = ifelse(grepl("cv", resample_method, ignore.case = TRUE), 10, 25),
  repeats = ifelse(grepl("dcv$", resample_method, ignore.case = TRUE), 3, NA),
  search = "random",
  sampling = NULL
)
}
\arguments{
\item{class}{A \code{factor} value for training data classes.}

\item{resample_method}{A \code{character} value for the resampling training method: "boot" (default), "cv", LOOCV", "repeatedcv".}

\item{number}{An \code{integer} value for the number of resampling iterations (25 default for boot) or folds (10 default for cross-validation).}

\item{repeats}{An \code{integer} value for the number of sets of folds for repeated cross-validation.}

\item{search}{A \code{character} value for the hyperparameter search strategy: "random" (default), "grid".}

\item{sampling}{A \code{character} value for the sampling strategy, sometimes used to fix class imbalances: \code{NULL} (default), "up", "down", "smote".}
}
\value{
A \code{trainControl} object for the \code{train} function.
}
\description{
The \code{ph_ctrl} function automatically generates a \code{trControl} object. This can be used in the \code{train}
function to automatically tune hyperparameters for every classification model in the ensemble.
}
\examples{
## Import data.
data(ph_crocs)
## Echo control object for train function.
ctrl <- ph_ctrl(ph_crocs$Species, resample_method = "boot")
}
