% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_or_install.R
\name{load_or_install}
\alias{load_or_install}
\title{Load or Install Packages.}
\usage{
load_or_install(package_names, ...)
}
\arguments{
\item{package_names}{Character vector of one or more package names.}

\item{...}{Additional arguments for \code{install.packages()}.}
}
\value{
Loaded packages.
}
\description{
Loads packages or, if not already installed, installs and loads packages.
}
\details{
Loads packages that are already installed, and if the packages are not
already installed, it installs and then loads them.
}
\examples{
\dontrun{
old <- options("repos")
options(repos = "https://cran.r-project.org")
# Warning: the command below installs packages that are not already installed
load_or_install(c("tidyverse","nlme"))
options(old)
}

}
\seealso{
\url{https://www.r-bloggers.com/2012/05/loading-andor-installing-packages-programmatically/}
\url{https://stackoverflow.com/questions/4090169/elegant-way-to-check-for-missing-packages-and-install-them}

Other packages: 
\code{\link{getDependencies}()}
}
\concept{packages}
