% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{rugged}
\alias{rugged}
\title{Rugged/Mountainous Terrain Data}
\format{
A data frame with 192 observations on the following 6 variables.
\describe{
\item{\code{ccode}}{a Correlates of War state code}
\item{\code{gwcode}}{a Gleditsch-Ward state code}
\item{\code{rugged}}{the terrain ruggedness index}
\item{\code{newlmtnest}}{the (natural log) percentage estimate of the state's terrain that is mountainous}
}
}
\usage{
rugged
}
\description{
This is a data set on state-level estimates for the "ruggedness" of a state's terrain.
}
\details{
The \code{data-raw} directory on the project's Github contains more information about how these data were
created. It goes without saying that these data move \emph{slowly} so the data are really only applicable for making state-to-state
comparisons and not states-in-time comparisons. The terrain ruggedness index is originally introduced by Riley et al. (1999) but
is amended by Nunn and Puga (2012). The mountain terrain data was originally created by Fearon and Laitin (2003) but extended and
amended by Gibler and Miller (2014). The data are functionally time-agnostic---use with caution in your state-year analyses---but all
data sets seem to benchmark around 1999-2000. I'm not sure it matters  \emph{that} much, but it matters a little at the margins, I suppose,
if you suspect there are major differences in interpretation of how much more "rugged" the Soviet Union was than Russia, or Yugoslavia
than Serbia.
}
\references{
Fearon, James D., and David Laitin, "Ethnicity, Insurgency, and Civil War"
\emph{American Political Science Review} 97: 75–90.

Gibler, Douglas M. and Steven V. Miller. 2014. "External Territorial Threat, State Capacity, and Civil War."
\emph{Journal of Peace Research} 51(5): 634-646.

Nunn, Nathan and Diego Puga. 2012. "Ruggedness: The Blessing of Bad Geography in Africa."
\emph{Review of Economics and Statistics}. 94(1): 20-36.

Riley, Shawn J., Stephen D. DeGloria, and Robert Elliot. 1999. "A Terrain Ruggedness
Index That Quantifies Topographic Heterogeneity,” \emph{Intermountain Journal of Sciences} 5: 23–27.
}
\keyword{datasets}
