% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iccplot.CRSM.R, R/iccplot.DRM.R,
%   R/iccplot.MPRM.R, R/iccplot.R
\name{iccplot.CRSM}
\alias{iccplot.CRSM}
\alias{iccplot.DRM}
\alias{iccplot.MPRM}
\alias{iccplot}
\title{Item Characteristic Curve}
\usage{
\method{iccplot}{CRSM}(object, items = "all", ...)

\method{iccplot}{DRM}(object, items = "all", ...)

\method{iccplot}{MPRM}(object, items = "all", ...)

iccplot(object, ...)
}
\arguments{
\item{object}{Object of class \code{CRSM} for ICC of the
CRSM or object of class \code{MPRM} for ICC plot of the MPRM or object of class \code{DRM} for ICC plot of the DRM}

\item{items}{Character vector \code{"all"} to display ICC curves for all items. By entering a numeric vector, a subset of items
can be chosen for which ICC plots are drawn.}

\item{\dots}{\dots{}}
}
\description{
The item characteristic curve is performed for the multidimensional polytomous
Rasch model or the continuous Rating Scale Model.
}
\details{
The item characteristic curve (ICC) plots the response probability depending on person and item parameter.
For plotting the ICC, the object resulting from MPRM \code{\link{MPRM}} or CRSM \code{\link{CRSM}} or DRM \code{\link{DRM}} is the input for the \code{iccplot} function.
The default argument \code{items="all"} displays ICC curves for all items in the object. With a numeric vector \code{items}, a subset of
items can be selected for which ICC plots are displayed.
}
\seealso{
\code{\link{MPRM}} \code{\link{CRSM}} \code{\link{DRM}}
}
\author{
Christine Hohensinn
}
