% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/111_pbd_opt.r
\name{Set Control Functions}
\alias{Set Control Functions}
\alias{pbd_opt}
\title{Set controls in pbdZMQ}
\usage{
pbd_opt(..., bytext = "", envir = .GlobalEnv)
}
\arguments{
\item{...}{in argument format \code{option = value} to set
\code{.pbd_env$option <- value} inside the \code{envir}}

\item{bytext}{in text format \code{"option = value"} to set
\code{.pbd_env$option <- value} inside the \code{envir}.}

\item{envir}{by default the global environment is used.}
}
\value{
No value is returned.
}
\description{
Set control functions
}
\details{
\code{pbd_opt()} sets pbd options for ZMQ controls.

\code{...} allows multiple options in
\code{envir$.pbd_env}, but only in a simple way.

\code{bytext} allows to assign options by text in
\code{envir$.pbd_env}, but can assign advanced objects. For example,
\code{"option$suboption <- value"} will set
\code{envir$.pbd_env$option$suboption <- value}.
}
\examples{
\dontrun{
library(pbdZMQ, quietly = TRUE)

ls(.pbd_env)
rm(.pbd_env)
.zmqopt_init()
ls(.pbd_env)

.pbd_env$ZMQ.SR$BLOCK
.pbd_opt(bytext = "ZMQ.SR$BLOCK <- 0L")
}

}
\author{
Wei-Chen Chen \email{wccsnow@gmail.com} and Drew Schmidt.
}
\references{
ZeroMQ/4.1.0 API Reference:
\url{http://api.zeromq.org/4-1:_start}

Programming with Big Data in R Website: \url{http://r-pbd.org/}
}
\seealso{
\code{\link{.pbd_env}}.
}
\keyword{programming}

