% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_mpi_blacs.r
\name{blacsexit}
\alias{blacsexit}
\alias{base.blacsexit}
\alias{blacsexit}
\title{BLACS Exit}
\usage{
base.blacsexit(CONT = TRUE)

blacsexit(CONT = TRUE)
}
\arguments{
\item{CONT}{logical; determines whether or not to shut down \emph{all} MPI
communicators}
}
\value{
Has an invisible return of 0 when successful.
}
\description{
Shuts down all BLACS communicators.
}
\details{
If the user wishes to shut down BLACS communicators but still have access to
MPI, then call this function with \code{CONT=TRUE}.  Calling
\code{blacsexit(CONT=FALSE)} will shut down all MPI communicators,
equivalent to calling

\code{> blacsexit(CONT=TRUE)} \code{> finalize(mpi.finalize=TRUE)}

This function is automatically invoked if BLACS communicators are running
and \code{finalize()} is called.
}
\examples{
spmd.code = "
  suppressMessages(library(pbdBASE))
  init.grid()

  blacsexit()

  # finalize()  # This should be off since blacexit().
"

pbdMPI::execmpi(spmd.code = spmd.code, nranks = 2L)

}
\keyword{BLACS}
