% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_register_target_with_maintenance_window}
\alias{ssm_register_target_with_maintenance_window}
\title{Registers a target with a maintenance window}
\usage{
ssm_register_target_with_maintenance_window(WindowId, ResourceType,
  Targets, OwnerInformation, Name, Description, ClientToken)
}
\arguments{
\item{WindowId}{[required] The ID of the maintenance window the target should be registered with.}

\item{ResourceType}{[required] The type of target being registered with the maintenance window.}

\item{Targets}{[required] The targets to register with the maintenance window. In other words, the
instances to run commands on when the maintenance window runs.

You can specify targets using either instance IDs or tags that have been
applied to instances.

\strong{Example 1}: Specify instance IDs

\code{Key=InstanceIds,Values=<i>instance-id-1</i>,<i>instance-id-2</i>,<i>instance-id-3</i> }

\strong{Example 2}: Use tag key-pairs applied to instances

\code{Key=tag:<i>my-tag-key</i>,Values=<i>my-tag-value-1</i>,<i>my-tag-value-2</i> }

\strong{Example 3}: Use tag-keys applied to instances

\code{Key=tag-key,Values=<i>my-tag-key-1</i>,<i>my-tag-key-2</i> }

For more information about these examples formats, including the best
use case for each one, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/mw-cli-tutorial-targets-examples.html}{Examples: Register Targets with a Maintenance Window}
in the \emph{AWS Systems Manager User Guide}.}

\item{OwnerInformation}{User-provided value that will be included in any CloudWatch events
raised while running tasks for these targets in this maintenance window.}

\item{Name}{An optional name for the target.}

\item{Description}{An optional description for the target.}

\item{ClientToken}{User-provided idempotency token.}
}
\description{
Registers a target with a maintenance window.
}
\section{Request syntax}{
\preformatted{svc$register_target_with_maintenance_window(
  WindowId = "string",
  ResourceType = "INSTANCE",
  Targets = list(
    list(
      Key = "string",
      Values = list(
        "string"
      )
    )
  ),
  OwnerInformation = "string",
  Name = "string",
  Description = "string",
  ClientToken = "string"
)
}
}

\keyword{internal}
