% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_create_patch_baseline}
\alias{ssm_create_patch_baseline}
\title{Creates a patch baseline}
\usage{
ssm_create_patch_baseline(OperatingSystem, Name, GlobalFilters,
  ApprovalRules, ApprovedPatches, ApprovedPatchesComplianceLevel,
  ApprovedPatchesEnableNonSecurity, RejectedPatches,
  RejectedPatchesAction, Description, Sources, ClientToken, Tags)
}
\arguments{
\item{OperatingSystem}{Defines the operating system the patch baseline applies to. The Default
value is WINDOWS.}

\item{Name}{[required] The name of the patch baseline.}

\item{GlobalFilters}{A set of global filters used to include patches in the baseline.}

\item{ApprovalRules}{A set of rules used to include patches in the baseline.}

\item{ApprovedPatches}{A list of explicitly approved patches for the baseline.

For information about accepted formats for lists of approved patches and
rejected patches, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html}{Package Name Formats for Approved and Rejected Patch Lists}
in the \emph{AWS Systems Manager User Guide}.}

\item{ApprovedPatchesComplianceLevel}{Defines the compliance level for approved patches. This means that if an
approved patch is reported as missing, this is the severity of the
compliance violation. The default value is UNSPECIFIED.}

\item{ApprovedPatchesEnableNonSecurity}{Indicates whether the list of approved patches includes non-security
updates that should be applied to the instances. The default value is
'false'. Applies to Linux instances only.}

\item{RejectedPatches}{A list of explicitly rejected patches for the baseline.

For information about accepted formats for lists of approved patches and
rejected patches, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html}{Package Name Formats for Approved and Rejected Patch Lists}
in the \emph{AWS Systems Manager User Guide}.}

\item{RejectedPatchesAction}{The action for Patch Manager to take on patches included in the
RejectedPackages list.
\itemize{
\item \strong{ALLOW\_AS\_DEPENDENCY}: A package in the Rejected patches list is
installed only if it is a dependency of another package. It is
considered compliant with the patch baseline, and its status is
reported as \emph{InstalledOther}. This is the default action if no
option is specified.
\item \strong{BLOCK}: Packages in the RejectedPatches list, and packages that
include them as dependencies, are not installed under any
circumstances. If a package was installed before it was added to the
Rejected patches list, it is considered non-compliant with the patch
baseline, and its status is reported as \emph{InstalledRejected}.
}}

\item{Description}{A description of the patch baseline.}

\item{Sources}{Information about the patches to use to update the instances, including
target operating systems and source repositories. Applies to Linux
instances only.}

\item{ClientToken}{User-provided idempotency token.}

\item{Tags}{Optional metadata that you assign to a resource. Tags enable you to
categorize a resource in different ways, such as by purpose, owner, or
environment. For example, you might want to tag a patch baseline to
identify the severity level of patches it specifies and the operating
system family it applies to. In this case, you could specify the
following key name/value pairs:
\itemize{
\item \code{Key=PatchSeverity,Value=Critical}
\item \code{Key=OS,Value=Windows}
}

To add tags to an existing patch baseline, use the AddTagsToResource
action.}
}
\description{
Creates a patch baseline.
}
\details{
For information about valid key and value pairs in \code{PatchFilters} for
each supported operating system type, see
\href{http://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html}{PatchFilter}.
}
\section{Request syntax}{
\preformatted{svc$create_patch_baseline(
  OperatingSystem = "WINDOWS"|"AMAZON_LINUX"|"AMAZON_LINUX_2"|"UBUNTU"|"REDHAT_ENTERPRISE_LINUX"|"SUSE"|"CENTOS",
  Name = "string",
  GlobalFilters = list(
    PatchFilters = list(
      list(
        Key = "PATCH_SET"|"PRODUCT"|"PRODUCT_FAMILY"|"CLASSIFICATION"|"MSRC_SEVERITY"|"PATCH_ID"|"SECTION"|"PRIORITY"|"SEVERITY",
        Values = list(
          "string"
        )
      )
    )
  ),
  ApprovalRules = list(
    PatchRules = list(
      list(
        PatchFilterGroup = list(
          PatchFilters = list(
            list(
              Key = "PATCH_SET"|"PRODUCT"|"PRODUCT_FAMILY"|"CLASSIFICATION"|"MSRC_SEVERITY"|"PATCH_ID"|"SECTION"|"PRIORITY"|"SEVERITY",
              Values = list(
                "string"
              )
            )
          )
        ),
        ComplianceLevel = "CRITICAL"|"HIGH"|"MEDIUM"|"LOW"|"INFORMATIONAL"|"UNSPECIFIED",
        ApproveAfterDays = 123,
        EnableNonSecurity = TRUE|FALSE
      )
    )
  ),
  ApprovedPatches = list(
    "string"
  ),
  ApprovedPatchesComplianceLevel = "CRITICAL"|"HIGH"|"MEDIUM"|"LOW"|"INFORMATIONAL"|"UNSPECIFIED",
  ApprovedPatchesEnableNonSecurity = TRUE|FALSE,
  RejectedPatches = list(
    "string"
  ),
  RejectedPatchesAction = "ALLOW_AS_DEPENDENCY"|"BLOCK",
  Description = "string",
  Sources = list(
    list(
      Name = "string",
      Products = list(
        "string"
      ),
      Configuration = "string"
    )
  ),
  ClientToken = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
