% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworkscm_operations.R
\name{opsworkscm_describe_node_association_status}
\alias{opsworkscm_describe_node_association_status}
\title{Returns the current status of an existing association or disassociation
request}
\usage{
opsworkscm_describe_node_association_status(NodeAssociationStatusToken,
  ServerName)
}
\arguments{
\item{NodeAssociationStatusToken}{[required] The token returned in either the AssociateNodeResponse or the
DisassociateNodeResponse.}

\item{ServerName}{[required] The name of the server from which to disassociate the node.}
}
\description{
Returns the current status of an existing association or disassociation
request.
}
\details{
A \code{ResourceNotFoundException} is thrown when no recent association or
disassociation request with the specified token is found, or when the
server does not exist. A \code{ValidationException} is raised when parameters
of the request are not valid.
}
\section{Request syntax}{
\preformatted{svc$describe_node_association_status(
  NodeAssociationStatusToken = "string",
  ServerName = "string"
)
}
}

\keyword{internal}
