% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_modify_cluster_maintenance}
\alias{redshift_modify_cluster_maintenance}
\title{Modifies the maintenance settings of a cluster}
\usage{
redshift_modify_cluster_maintenance(ClusterIdentifier, DeferMaintenance,
  DeferMaintenanceIdentifier, DeferMaintenanceStartTime,
  DeferMaintenanceEndTime, DeferMaintenanceDuration)
}
\arguments{
\item{ClusterIdentifier}{[required] A unique identifier for the cluster.}

\item{DeferMaintenance}{A boolean indicating whether to enable the deferred maintenance window.}

\item{DeferMaintenanceIdentifier}{A unique identifier for the deferred maintenance window.}

\item{DeferMaintenanceStartTime}{A timestamp indicating the start time for the deferred maintenance
window.}

\item{DeferMaintenanceEndTime}{A timestamp indicating end time for the deferred maintenance window. If
you specify an end time, you can't specify a duration.}

\item{DeferMaintenanceDuration}{An integer indicating the duration of the maintenance window in days. If
you specify a duration, you can't specify an end time. The duration must
be 45 days or less.}
}
\value{
A list with the following syntax:\preformatted{list(
  Cluster = list(
    ClusterIdentifier = "string",
    NodeType = "string",
    ClusterStatus = "string",
    ClusterAvailabilityStatus = "string",
    ModifyStatus = "string",
    MasterUsername = "string",
    DBName = "string",
    Endpoint = list(
      Address = "string",
      Port = 123,
      VpcEndpoints = list(
        list(
          VpcEndpointId = "string"
        )
      )
    ),
    ClusterCreateTime = as.POSIXct(
      "2015-01-01"
    ),
    AutomatedSnapshotRetentionPeriod = 123,
    ManualSnapshotRetentionPeriod = 123,
    ClusterSecurityGroups = list(
      list(
        ClusterSecurityGroupName = "string",
        Status = "string"
      )
    ),
    VpcSecurityGroups = list(
      list(
        VpcSecurityGroupId = "string",
        Status = "string"
      )
    ),
    ClusterParameterGroups = list(
      list(
        ParameterGroupName = "string",
        ParameterApplyStatus = "string",
        ClusterParameterStatusList = list(
          list(
            ParameterName = "string",
            ParameterApplyStatus = "string",
            ParameterApplyErrorDescription = "string"
          )
        )
      )
    ),
    ClusterSubnetGroupName = "string",
    VpcId = "string",
    AvailabilityZone = "string",
    PreferredMaintenanceWindow = "string",
    PendingModifiedValues = list(
      MasterUserPassword = "string",
      NodeType = "string",
      NumberOfNodes = 123,
      ClusterType = "string",
      ClusterVersion = "string",
      AutomatedSnapshotRetentionPeriod = 123,
      ClusterIdentifier = "string",
      PubliclyAccessible = TRUE|FALSE,
      EnhancedVpcRouting = TRUE|FALSE,
      MaintenanceTrackName = "string",
      EncryptionType = "string"
    ),
    ClusterVersion = "string",
    AllowVersionUpgrade = TRUE|FALSE,
    NumberOfNodes = 123,
    PubliclyAccessible = TRUE|FALSE,
    Encrypted = TRUE|FALSE,
    RestoreStatus = list(
      Status = "string",
      CurrentRestoreRateInMegaBytesPerSecond = 123.0,
      SnapshotSizeInMegaBytes = 123,
      ProgressInMegaBytes = 123,
      ElapsedTimeInSeconds = 123,
      EstimatedTimeToCompletionInSeconds = 123
    ),
    DataTransferProgress = list(
      Status = "string",
      CurrentRateInMegaBytesPerSecond = 123.0,
      TotalDataInMegaBytes = 123,
      DataTransferredInMegaBytes = 123,
      EstimatedTimeToCompletionInSeconds = 123,
      ElapsedTimeInSeconds = 123
    ),
    HsmStatus = list(
      HsmClientCertificateIdentifier = "string",
      HsmConfigurationIdentifier = "string",
      Status = "string"
    ),
    ClusterSnapshotCopyStatus = list(
      DestinationRegion = "string",
      RetentionPeriod = 123,
      ManualSnapshotRetentionPeriod = 123,
      SnapshotCopyGrantName = "string"
    ),
    ClusterPublicKey = "string",
    ClusterNodes = list(
      list(
        NodeRole = "string",
        PrivateIPAddress = "string",
        PublicIPAddress = "string"
      )
    ),
    ElasticIpStatus = list(
      ElasticIp = "string",
      Status = "string"
    ),
    ClusterRevisionNumber = "string",
    Tags = list(
      list(
        Key = "string",
        Value = "string"
      )
    ),
    KmsKeyId = "string",
    EnhancedVpcRouting = TRUE|FALSE,
    IamRoles = list(
      list(
        IamRoleArn = "string",
        ApplyStatus = "string"
      )
    ),
    PendingActions = list(
      "string"
    ),
    MaintenanceTrackName = "string",
    ElasticResizeNumberOfNodeOptions = "string",
    DeferredMaintenanceWindows = list(
      list(
        DeferMaintenanceIdentifier = "string",
        DeferMaintenanceStartTime = as.POSIXct(
          "2015-01-01"
        ),
        DeferMaintenanceEndTime = as.POSIXct(
          "2015-01-01"
        )
      )
    ),
    SnapshotScheduleIdentifier = "string",
    SnapshotScheduleState = "MODIFYING"|"ACTIVE"|"FAILED",
    ExpectedNextSnapshotScheduleTime = as.POSIXct(
      "2015-01-01"
    ),
    ExpectedNextSnapshotScheduleTimeStatus = "string",
    NextMaintenanceWindowStartTime = as.POSIXct(
      "2015-01-01"
    ),
    ResizeInfo = list(
      ResizeType = "string",
      AllowCancelResize = TRUE|FALSE
    ),
    AvailabilityZoneRelocationStatus = "string",
    ClusterNamespaceArn = "string"
  )
)
}
}
\description{
Modifies the maintenance settings of a cluster.
}
\section{Request syntax}{
\preformatted{svc$modify_cluster_maintenance(
  ClusterIdentifier = "string",
  DeferMaintenance = TRUE|FALSE,
  DeferMaintenanceIdentifier = "string",
  DeferMaintenanceStartTime = as.POSIXct(
    "2015-01-01"
  ),
  DeferMaintenanceEndTime = as.POSIXct(
    "2015-01-01"
  ),
  DeferMaintenanceDuration = 123
)
}
}

\keyword{internal}
