% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costexplorer_operations.R
\name{costexplorer_get_cost_and_usage}
\alias{costexplorer_get_cost_and_usage}
\title{Retrieves cost and usage metrics for your account}
\usage{
costexplorer_get_cost_and_usage(
  TimePeriod,
  Granularity,
  Filter = NULL,
  Metrics,
  GroupBy = NULL,
  BillingViewArn = NULL,
  NextPageToken = NULL
)
}
\arguments{
\item{TimePeriod}{[required] Sets the start date and end date for retrieving Amazon Web Services
costs. The start date is inclusive, but the end date is exclusive. For
example, if \code{start} is \code{2017-01-01} and \code{end} is \code{2017-05-01}, then the
cost and usage data is retrieved from \code{2017-01-01} up to and including
\code{2017-04-30} but not including \code{2017-05-01}.}

\item{Granularity}{[required] Sets the Amazon Web Services cost granularity to \code{MONTHLY} or \code{DAILY},
or \code{HOURLY}. If \code{Granularity} isn't set, the response object doesn't
include the \code{Granularity}, either \code{MONTHLY} or \code{DAILY}, or \code{HOURLY}.}

\item{Filter}{Filters Amazon Web Services costs by different dimensions. For example,
you can specify \code{SERVICE} and \code{LINKED_ACCOUNT} and get the costs that
are associated with that account's usage of that service. You can nest
\code{Expression} objects to define any combination of dimension filters. For
more information, see
\href{https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html}{Expression}.

Valid values for \code{MatchOptions} for \code{Dimensions} are \code{EQUALS} and
\code{CASE_SENSITIVE}.

Valid values for \code{MatchOptions} for \code{CostCategories} and \code{Tags} are
\code{EQUALS}, \code{ABSENT}, and \code{CASE_SENSITIVE}. Default values are \code{EQUALS}
and \code{CASE_SENSITIVE}.}

\item{Metrics}{[required] Which metrics are returned in the query. For more information about
blended and unblended rates, see Why does the "blended" annotation
appear on some line items in my bill?.

Valid values are \code{AmortizedCost}, \code{BlendedCost}, \code{NetAmortizedCost},
\code{NetUnblendedCost}, \code{NormalizedUsageAmount}, \code{UnblendedCost}, and
\code{UsageQuantity}.

If you return the \code{UsageQuantity} metric, the service aggregates all
usage numbers without taking into account the units. For example, if you
aggregate \code{usageQuantity} across all of Amazon EC2, the results aren't
meaningful because Amazon EC2 compute hours and data transfer are
measured in different units (for example, hours and GB). To get more
meaningful \code{UsageQuantity} metrics, filter by \code{UsageType} or
\code{UsageTypeGroups}.

\code{Metrics} is required for
\code{\link[=costexplorer_get_cost_and_usage]{get_cost_and_usage}} requests.}

\item{GroupBy}{You can group Amazon Web Services costs using up to two different
groups, either dimensions, tag keys, cost categories, or any two group
by types.

Valid values for the \code{DIMENSION} type are \code{AZ}, \code{INSTANCE_TYPE},
\code{LEGAL_ENTITY_NAME}, \code{INVOICING_ENTITY}, \code{LINKED_ACCOUNT}, \code{OPERATION},
\code{PLATFORM}, \code{PURCHASE_TYPE}, \code{SERVICE}, \code{TENANCY}, \code{RECORD_TYPE}, and
\code{USAGE_TYPE}.

When you group by the \code{TAG} type and include a valid tag key, you get
all tag values, including empty strings.}

\item{BillingViewArn}{The Amazon Resource Name (ARN) that uniquely identifies a specific
billing view. The ARN is used to specify which particular billing view
you want to interact with or retrieve information from when making API
calls related to Amazon Web Services Billing and Cost Management
features. The BillingViewArn can be retrieved by calling the
ListBillingViews API.}

\item{NextPageToken}{The token to retrieve the next set of results. Amazon Web Services
provides the token when the response from a previous call has more
results than the maximum page size.}
}
\description{
Retrieves cost and usage metrics for your account. You can specify which cost and usage-related metric that you want the request to return. For example, you can specify \code{BlendedCosts} or \code{UsageQuantity}. You can also filter and group your data by various dimensions, such as \code{SERVICE} or \code{AZ}, in a specific time range. For a complete list of valid dimensions, see the \code{\link[=costexplorer_get_dimension_values]{get_dimension_values}} operation. Management account in an organization in Organizations have access to all member accounts.

See \url{https://www.paws-r-sdk.com/docs/costexplorer_get_cost_and_usage/} for full documentation.
}
\keyword{internal}
