% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patternbar.R
\name{patternbar}
\alias{patternbar}
\title{Plot a bar chart using patterns and colors to fill the bars.}
\usage{
patternbar(
  data,
  x,
  y,
  group = NULL,
  xlab = "",
  ylab = "",
  label.size = 3.5,
  vjust = -1,
  hjust = -1,
  pattern.type,
  pattern.line.size = rep(5, ifelse(is.null(group), length(x), length(unique(group)))),
  pattern.color = rep("black", ifelse(is.null(group), length(x),
    length(unique(group)))),
  background.color = rep("white", ifelse(is.null(group), length(x),
    length(unique(group)))),
  frame.color = rep("black", ifelse(is.null(group), length(x), length(unique(group)))),
  frame.size = 1,
  pixel = 20,
  density = rep(7, ifelse(is.null(group), length(x), length(unique(group)))),
  legend.type = "h",
  legend.h = 6,
  legend.x.pos = 1.1,
  legend.y.pos = 0.49,
  legend.w = 0.2,
  legend.pixel = 20,
  bar.width = 0.9
)
}
\arguments{
\item{data}{the data to be used.}

\item{x}{the variable used on x axis.}

\item{y}{the variable used on y axis.}

\item{group}{the variable used as the second grouping variable on x axis.}

\item{xlab}{a character string to give x axis label.}

\item{ylab}{a character string to give y axis label.}

\item{label.size}{the font size of legend labels shown above the bars.}

\item{vjust}{the vertical distance of labels from the top border of each bar.}

\item{hjust}{the horizontal distance of labels from the top border of each bar.}

\item{pattern.type}{a vector of patterns to be filled in the bars 
The pattern types include: 'blank', 'bricks', 'vdashes', 'hdashes', 'crosshatch','dots', 
'grid','hlines','nelines', 'nwlines', 'vlines', 'waves' and more.}

\item{pattern.line.size}{a vector of numeric values, the line size for the lines/dots of patterns.}

\item{pattern.color}{a vector of colors for the lines/dots of patterns.}

\item{background.color}{a vector of colors to be filled in the bars.}

\item{frame.color}{the color for the borders of bars.}

\item{frame.size}{a numeric value, the line size for the borders of bars.}

\item{pixel}{a numeric value, the pixel resolution of bar chart.}

\item{density}{a numeric vector, the density for the lines/dots of patterns.}

\item{legend.type}{if legend.type='h', the layout of legends is horizontal; if legend.type='v', the layout of legends is vertical.}

\item{legend.h}{a numeric value to change the height of legend boxes.}

\item{legend.x.pos}{a numeric value to change the position of legends on x axis.}

\item{legend.y.pos}{a numeric value to change the position of legends on y axis.}

\item{legend.w}{a numeric value to change the width of legends.}

\item{legend.pixel}{a numeric value to change pixel of legends.}

\item{bar.width}{a numeric value to change the width of the bars.}
}
\value{
A ggplot object.
}
\description{
The \code{patternbar} function is a tool for creating versatile bar charts 
by filling the bars with colors and patterns.
}
\details{
\code{patternbar} function offers flexible ways of doing bar charts.
}
\examples{
#Example 1
library(patternplot)
library(png)
library(ggplot2)
data <- read.csv(system.file("extdata", "monthlyexp.csv", package="patternplot"))
data<-data[which(data$Location=='City 1'),]
x<-factor(data$Type, c('Housing', 'Food',  'Childcare'))
y<-data$Amount
pattern.type<-c('hdashes', 'blank', 'crosshatch')
pattern.color=c('black','black', 'black')
background.color=c('white','white', 'white')
density<-c(20, 20, 10)
patternbar(data,x, y,group=NULL,ylab='Monthly Expenses, Dollars', pattern.type=pattern.type,
pattern.color=pattern.color,background.color=background.color,pattern.line.size=c(5.5, 1, 4),
frame.color=rep('black', 3),density=density)+scale_y_continuous(limits = c(0, 2800))

#Example 2
pattern.color=c('black','white', 'grey20')
background.color=c('lightgreen','lightgreen', 'lightgreen')
patternbar(data,x, y,group=NULL,ylab='Monthly Expenses, Dollars', pattern.type=pattern.type,
pattern.color=pattern.color, background.color=background.color,pattern.line.size=c(5.5, 1, 4),
frame.color=rep('black', 3), density=density)+scale_y_continuous(limits = c(0, 2800))

}
\seealso{
Function \code{imagebar}
}
\author{
Chunqiao Luo (chunqiaoluo@gmail.com)
}
