% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleLandmarks.R
\name{sampleLandmarks}
\alias{sampleLandmarks}
\title{Sample landmarks in an image.}
\usage{
sampleLandmarks(sampleList, resampleFactor = NULL, crop = c(0, 0, 0, 0))
}
\arguments{
\item{sampleList}{RasterStack or list of RasterStack objects as obtained
by \code{\link{makeList}}.}

\item{resampleFactor}{Integer for downsampling the image(s) used by \code{\link{redRes}}.}

\item{crop}{Vector c(xmin, xmax, ymin, ymax) that specifies the pixel coordinates to crop the
original image.}
}
\value{
landmark matrix or landmark list
}
\description{
Sample landmarks in an image.
}
\examples{

\dontrun{
IDlist <- c('BC0077','BC0071')
prepath <- system.file("extdata",  package = 'patternize')
extension <- '.jpg'
imageList <- makeList(IDlist, 'image', prepath, extension)

landmarkList <- sampleLandmarks(imageList)
}

}
