% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{pc_matrix}
\alias{pc_matrix}
\title{Pattern Causality Matrix Object}
\usage{
pc_matrix(
  positive = NULL,
  negative = NULL,
  dark = NULL,
  items = NULL,
  verbose = TRUE
)
}
\arguments{
\item{positive}{Positive causality matrix.}

\item{negative}{Negative causality matrix.}

\item{dark}{Dark causality matrix.}

\item{items}{Names of items in the matrices.}

\item{verbose}{Logical, whether to print progress information.}
}
\value{
An object of class "pc_matrix".
}
\description{
Creates a pattern causality matrix object.
This function constructs an object of class \code{pc_matrix} containing the positive,
negative, and dark causality matrices, along with item names.
}
\examples{
data(climate_indices)
dataset <- climate_indices[, -1]
pc_matrix_obj <- pcMatrix(dataset, E = 3, tau = 1, 
  metric = "euclidean", h = 1, weighted = TRUE, 
  verbose = FALSE)
print(pc_matrix_obj)
}
