% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analytical_functions.R
\name{get_dist_point_line}
\alias{get_dist_point_line}
\title{Compute distance between a point and a line}
\usage{
get_dist_point_line(point, line_coord1, line_coord2)
}
\arguments{
\item{point}{2D or 3D coordinates of the point as c(x,y) or c(x,y,z)}

\item{line_coord1}{2D or 3D coordinates of one point on the line as c(x,y) or
c(x,y,z)}

\item{line_coord2}{2D or 3D coordinates of a second point on the line as
c(x,y) or c(x,y,z)}
}
\value{
A numeric vector of length 1 that provides the euclidean distance
between the point and the line.
}
\description{
Compute distance between a point and a line
}
\details{
The function accepts 2D coordinates or 3D coordinates, but note that
the dimensions of all supplied arguments must match; all coordinates must
be 2D or they all must be 3D.
}
\examples{
## 2D case
get_dist_point_line(
  point = c(0, 0),
  line_coord1 = c(1, 0),
  line_coord2 = c(1, 5)
)

## 3D case
get_dist_point_line(
  point = c(0, 0, 0),
  line_coord1 = c(1, 0, 0),
  line_coord2 = c(1, 5, 0)
)
}
\seealso{
Other mathematical functions: 
\code{\link{calc_min_dist_v}()},
\code{\link{deg_2_rad}()},
\code{\link{find_curve_elbow}()},
\code{\link{get_2d_angle}()},
\code{\link{get_3d_angle}()},
\code{\link{get_3d_cross_prod}()},
\code{\link{get_traj_velocities}()},
\code{\link{get_velocity}()},
\code{\link{rad_2_deg}()}
}
\author{
Vikram B. Baliga
}
\concept{mathematical functions}
