% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/paths.R
\name{choose_dir}
\alias{choose_dir}
\alias{choose_files}
\title{Choose files interactively}
\usage{
choose_dir(default = "", sep = c("/", "\\\\"))

choose_files(default = "", multi = FALSE, sep = c("/", "\\\\"))
}
\arguments{
\item{default}{The default file to be selected.  See the Details section of
\code{choose.files} for how to specify.  Only on Windows.}

\item{sep}{String separator between directory levels in the output.}

\item{multi}{Logical value indicating if multiple files can be selected.
Only on Windows.}
}
\value{
A character vector of standardized file paths that were chosen.
}
\description{
Choose one or more files or a directory interactively using a pop-up dialog.
}
\note{
\code{choose_files} uses \code{choose.files} under Windows
and \code{\link[base]{file.choose}} under other platforms.
}
\examples{
\donttest{
choose_files()
if(assertive.reflection::is_windows())
{
  choose_dir()
}
}
}

