% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrim_regularized.R
\name{discrim_regularized}
\alias{discrim_regularized}
\title{Regularized discriminant analysis}
\usage{
discrim_regularized(
  mode = "classification",
  frac_common_cov = NULL,
  frac_identity = NULL,
  engine = "klaR"
)
}
\arguments{
\item{mode}{A single character string for the prediction outcome mode.
Possible values for this model are "unknown", "regression", or
"classification".}

\item{frac_common_cov, frac_identity}{Numeric values between zero and one.}

\item{engine}{A single character string specifying what computational engine
to use for fitting.}
}
\description{
\code{discrim_regularized()} defines a model that estimates a multivariate
distribution for the predictors separately for the data in each class. The
structure of the model can be LDA, QDA, or some amalgam of the two. Bayes'
theorem is used to compute the probability of each class, given the
predictor values. This function can fit classification models.

\Sexpr[stage=render,results=rd]{parsnip:::make_engine_list("discrim_regularized")}

More information on how \pkg{parsnip} is used for modeling is at
\url{https://www.tidymodels.org/}.
}
\details{
There are many ways of regularizing models. For example, one form of
regularization is to penalize model parameters. Similarly, the classic
James–Stein regularization approach shrinks the model structure to a less
complex form.

The model fits a very specific type of regularized model by Friedman (1989)
that uses two types of regularization. One modulates how class-specific the
covariance matrix should be. This allows the model to balance between LDA
and QDA. The second regularization component shrinks the covariance matrix
towards the identity matrix.

For the penalization approach, \code{\link[=discrim_linear]{discrim_linear()}} with a \code{mda} engine can be
used. Other regularization methods can be used with \code{\link[=discrim_linear]{discrim_linear()}} and
\code{\link[=discrim_quad]{discrim_quad()}} can used via the \code{sparsediscrim} engine for those functions.

This function only defines what \emph{type} of model is being fit. Once an engine
is specified, the \emph{method} to fit the model is also defined. See
\code{\link[=set_engine]{set_engine()}} for more on setting the engine, including how to set engine
arguments.

The model is not trained or fit until the \code{\link[=fit.model_spec]{fit()}} function is used
with the data.

Each of the arguments in this function other than \code{mode} and \code{engine} are
captured as \link[rlang:topic-quosure]{quosures}. To pass values
programmatically, use the \link[rlang:injection-operator]{injection operator} like so:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{value <- 1
discrim_regularized(argument = !!value)
}\if{html}{\out{</div>}}
}
\references{
\url{https://www.tidymodels.org}, \href{https://www.tmwr.org/}{\emph{Tidy Modeling with R}}, \href{https://www.tidymodels.org/find/parsnip/}{searchable table of parsnip models}

Friedman, J (1989). Regularized Discriminant Analysis. \emph{Journal of the
American Statistical Association}, 84, 165-175.
}
\seealso{
\Sexpr[stage=render,results=rd]{parsnip:::make_seealso_list("discrim_regularized")}
}
