% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rand_forest_randomForest.R
\name{details_rand_forest_randomForest}
\alias{details_rand_forest_randomForest}
\title{Random forests via randomForest}
\description{
\code{\link[randomForest:randomForest]{randomForest::randomForest()}} fits a model that creates a large number of
decision trees, each independent of the others. The final prediction uses all
predictions from the individual trees and combines them.
}
\details{
For this engine, there are multiple modes: classification and regression
\subsection{Tuning Parameters}{

This model has 3 tuning parameters:
\itemize{
\item \code{mtry}: # Randomly Selected Predictors (type: integer, default: see
below)
\item \code{trees}: # Trees (type: integer, default: 500L)
\item \code{min_n}: Minimal Node Size (type: integer, default: see below)
}

\code{mtry} depends on the number of columns and the model mode. The default
in \code{\link[randomForest:randomForest]{randomForest::randomForest()}} is
\code{floor(sqrt(ncol(x)))} for classification and \code{floor(ncol(x)/3)} for
regression.

\code{min_n} depends on the mode. For regression, a value of 5 is the
default. For classification, a value of 10 is used.
}

\subsection{Translation from parsnip to the original package (regression)}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{rand_forest(
  mtry = integer(1),
  trees = integer(1),
  min_n = integer(1)
) \%>\%  
  set_engine("randomForest") \%>\% 
  set_mode("regression") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Random Forest Model Specification (regression)
## 
## Main Arguments:
##   mtry = integer(1)
##   trees = integer(1)
##   min_n = integer(1)
## 
## Computational engine: randomForest 
## 
## Model fit template:
## randomForest::randomForest(x = missing_arg(), y = missing_arg(), 
##     mtry = min_cols(~integer(1), x), ntree = integer(1), nodesize = min_rows(~integer(1), 
##         x))
}\if{html}{\out{</div>}}

\code{min_rows()} and \code{min_cols()} will adjust the number of neighbors if the
chosen value if it is not consistent with the actual data dimensions.
}

\subsection{Translation from parsnip to the original package (classification)}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{rand_forest(
  mtry = integer(1),
  trees = integer(1),
  min_n = integer(1)
) \%>\% 
  set_engine("randomForest") \%>\% 
  set_mode("classification") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Random Forest Model Specification (classification)
## 
## Main Arguments:
##   mtry = integer(1)
##   trees = integer(1)
##   min_n = integer(1)
## 
## Computational engine: randomForest 
## 
## Model fit template:
## randomForest::randomForest(x = missing_arg(), y = missing_arg(), 
##     mtry = min_cols(~integer(1), x), ntree = integer(1), nodesize = min_rows(~integer(1), 
##         x))
}\if{html}{\out{</div>}}
}

\subsection{Preprocessing requirements}{

This engine does not require any special encoding of the predictors.
Categorical predictors can be partitioned into groups of factor levels
(e.g. \verb{\{a, c\}} vs \verb{\{b, d\}}) when splitting at a node. Dummy variables
are not required for this model.
}

\subsection{Saving fitted model objects}{

This model object contains data that are not required to make
predictions. When saving the model for the purpose of prediction, the
size of the saved object might be substantially reduced by using
functions from the \href{https://butcher.tidymodels.org}{butcher} package.
}

\subsection{Examples}{

The “Fitting and Predicting with parsnip” article contains
\href{https://parsnip.tidymodels.org/articles/articles/Examples.html#rand-forest-randomForest}{examples}
for \code{rand_forest()} with the \code{"randomForest"} engine.
}

\subsection{References}{
\itemize{
\item Kuhn, M, and K Johnson. 2013. \emph{Applied Predictive Modeling}. Springer.
}
}
}
\keyword{internal}
