% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduce_whitespace.R
\name{reduce_whitespace}
\alias{reduce_whitespace}
\title{Remove excess whitespace recursively}
\usage{
reduce_whitespace(items, recursive = TRUE, all = FALSE)
}
\arguments{
\item{items}{A \link{LaTeX2} object.}

\item{recursive}{Apply to all lists within \code{items}.}

\item{all}{If \code{TRUE}, remove all white space, not just doubles.}
}
\value{
\code{items} with double spaces or double newlines set to single,
and trailing spaces removed (or all whitespace removed, if \code{all} is \code{TRUE}).
}
\description{
Remove excess whitespace recursively
}
\examples{
parsed <- parseLatex("a  {b\n\nc}")
parsed
reduce_whitespace(parsed)
}
