% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parafac_fun.R
\name{parafac_fun}
\alias{parafac_fun}
\title{PARAFAC loss function calculation}
\usage{
parafac_fun(x, Tensor, lambdas = NULL)
}
\arguments{
\item{x}{Vector of fitted loadings generated by the PARAFAC algorithm, can also be a Fac object}

\item{Tensor}{input data}

\item{lambdas}{If lambdas (from the kruskal tensor case) are generated to make the Fac norm 1, they can be supplied.}
}
\value{
Scalar value of the loss function
}
\description{
PARAFAC loss function calculation
}
\examples{
A = array(rnorm(108*2), c(108,2))
B = array(rnorm(100*2), c(100,2))
C = array(rnorm(10*2), c(10,2))
X = reinflateTensor(A, B, C)
model = parafac(X, 2)
f = parafac_fun(model$Fac, X)
}
