% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importMicrobiotaProcess.R
\name{importMicrobiotaProcess}
\alias{importMicrobiotaProcess}
\title{Import MicrobiotaProcess object for PARAFAC modelling}
\usage{
importMicrobiotaProcess(MPobject, subjectIDs, thirdMode, taxa_are_rows = TRUE)
}
\arguments{
\item{MPobject}{MicrobiotaProcess object containing at least an OTU table and sample information, preferably also taxonomic information.}

\item{subjectIDs}{Column name in the sample information corresponding to the subject IDs.}

\item{thirdMode}{Column name in the sample information corresponding to the study design aspect to put in the third mode of the data cube.}

\item{taxa_are_rows}{Boolean specifying if the taxa are in the rows of the OTU table (TRUE) or not (FALSE).}
}
\value{
List object containing:
\itemize{
\item 'data': data cube
\item 'mode1': metadata of the subject mode
\item 'mode2': taxonomy information
\item 'mode3': metadata of the third mode
}
}
\description{
Import MicrobiotaProcess object for PARAFAC modelling
}
\examples{
\dontshow{if (rlang::is_installed("MicrobiotaProcess")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
library(MicrobiotaProcess)
data("mouse.time.mpse")
importMicrobiotaProcess(mouse.time.mpse, subjectIDs = "Sample",
                        thirdMode = "time", taxa_are_rows = TRUE)
}
\dontshow{\}) # examplesIf}
}
