% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting_funcs.R
\name{center_interval}
\alias{center_interval}
\title{Shift to the middle of each interval}
\usage{
center_interval(x, shift = c("up", "down"), interval = NULL)
}
\arguments{
\item{x}{A vector of class \code{Date}, \code{POSIXct} or \code{POSIXlt}.}

\item{shift}{"up" or "down".}

\item{interval}{The interval to be used for centering. If \code{NULL},
\code{get_interval} will be applied on \code{x}.}
}
\value{
Vector of the same class as \code{x}, with the values shifted to the
(approximate) center.
}
\description{
After thickening all the values are either
shifted to the first or the last value of their interval.
This function creates a vector from \code{x}, with the values shifted to
the (approximate) center of the interval. This can give a more accurate
picture of the aggregated data when plotting.
}
\details{
The interval will be translated to number of days when
\code{x} is of class \code{Date}, or number of seconds when \code{x} is of
class \code{POSIXt}. For months and quarters this will be the average
length of the interval. The translated units divided by two
will be added by or subtracted from each value of \code{x}.
}
\examples{
library(dplyr)
library(ggplot2)
plot_set <- emergency \%>\%
  thicken("hour", "h") \%>\%
  count(h) \%>\%
  head(24)

ggplot(plot_set, aes(h, n)) + geom_col()

plot_set \%>\%
  mutate(h_center = center_interval(h)) \%>\%
  ggplot(aes(h_center, n)) + geom_col()
}
