% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.R
\name{Peek}
\alias{Peek}
\title{Load samples from a partial MCMC run}
\usage{
Peek(backing.path)
}
\arguments{
\item{backing.path}{directory path of an in-progress MCMC}
}
\value{
list of \link{big.matrix} with samples from the partial MCMC run
}
\description{
\code{Peek} allows the samples from a file-backed MCMC to be loaded in
another R session while the MCMC is still in progress.  By using \code{Peek},
the chain's convergence can be monitored before the MCMC chain has finished
running.
}
\examples{
\donttest{
SampleSomething <- function() {
    Sys.sleep(0.1)
    rnorm(1)
}

backing.path <- tempfile()
dir.create(backing.path)
print(backing.path)

SlowMcmc <- InitMcmc(1000, backing.path=backing.path)
SlowMcmc({
    x <- SampleSomething()
})

### In another R process, while the MCMC is still running...
samples.so.far <- Peek(backing.path)
samples.so.far$x[,]
}
}
\seealso{
\code{\link{InitMcmc}}, \code{\link{LoadMcmc}},
  \code{\link{big.matrix}}
}
