% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panel.R
\name{remargin}
\alias{remargin}
\title{Adjust margins of a ggplot2 plot}
\usage{
remargin(g, t, r, b, l, unit = "npc")
}
\arguments{
\item{g}{A \code{ggplot2} plot.}

\item{t, r, b, l}{Top, right, bottom, and left margins to set.}

\item{unit}{Unit for the margins (see \code{\link[grid:unit]{grid::unit()}} for permissible units).
The default, \code{"npc"}, refers to fractions of the overall plot area.}
}
\value{
A \code{ggplot2} plot with margins adjusted.
}
\description{
To avoid the overlay rectangles moving around when the plot margins change,
you can use this function to set specific margins for your plot. You will
probably want to specify a large enough margin so that the axes and legends
don't go out of the plot area.
}
\details{
Note that this only works with \code{ggplot2} plots. For base plots, you can set
the margins using \code{par(plt = c(x1, x2, y1, y2))}. See \code{\link[graphics:par]{graphics::par()}} for
details.
}
\examples{
plot1 = ggplot2::ggplot(data.frame(x = rnorm(10), y = rnorm(10))) +
    ggplot2::geom_point(ggplot2::aes(x, y))
plot2 = remargin(plot1, 0.1, 0.1, 0.1, 0.1) # plot with 10\% margins all around

}
