% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VLE_learning_classification.R
\name{VLE_learning_classification}
\alias{VLE_learning_classification}
\title{Classify VLE activities}
\usage{
VLE_learning_classification(
  activity_data,
  classification = c("FSLM", "FSLSM", "OLS", "VARK")
)
}
\arguments{
\item{activity_data}{VLE activity data set to be converted.}

\item{classification}{classification system to be used to categorise the different VLE activities under.}
}
\value{
Returns the classification specified, the mapping for the VLE activities to each category in the specified
learning model, and one tibble, VLE_classified_data.
}
\description{
Transform Open University VLE activities to classifications under either the:
\itemize{
\item{Filder-Selverman Learning Style Model (FSLM) mapped by Balti at al. (2023),}
\item{Felder–Silverman Learning Style Model (FSLSM) (see Felder & Silverman, 1988) mapped by Nazempour and Darabi (2023),}
\item{VARK Learning Style Model (see Fleming and Colleen, 1992) mapped by Balti at al. (2023), or}
\item{Corresponding to the Online Learning Style Characteristics (OLS) mapped by Yan et al. (2021) and drawing
on Li and Yin (2017).}
}
}
\section{VLE_classified_data}{

A tibble where each row represents a unique student and their number of interactions with
different categories of the specified learning model.
}

\examples{
\donttest{
VLE_data = dataset_VLE_activity(example_data = TRUE)$resource_data
VLE_learning_classification(VLE_data, classification = "FSLSM")}
}
\references{
Balti, R., Hedhili, A., Chaari, W.L. & Abed, M. (2023). Hybrid analysis of the learner’s online behavior based
on learning style. Education and Information Technologies. https://doi.org/10.1007/s10639-023-11595-x

Felder, R. M., & Silverman, L. K. (1988). Learning and Teaching Styles in Engineering Education.
Engineering Education, 78(7), 674–681. https://www.engr.ncsu.edu/wp-content/uploads/drive/1QP6kBI1iQmpQbTXL-08HSl0PwJ5BYnZW/1988-LS-plus-note.pdf

Fleming, N. D., & Mills, C. (1992). Not Another Inventory, Rather a Catalyst for Reflection.
To Improve the Academy. 246. https://digitalcommons.unl.edu/podimproveacad/246

Kuzilek, J., Hlosta, M., & Zdrahal, Z. (2017). Open university learning analytics dataset. Scientific Data
volume 4 , (pp. 1–8). https://doi.org/10.1038/sdata.2017.171.

Li, R., & Yin, C. (2017). Analysis of Online Learning Style Model Based on K-means Algorithm.
Proceedings of the 3rd International Conference on Economics, Management, Law and Education (EMLE 2017).
(pp. 692-697). Atlantis Press. https://doi.org/10.2991/emle-17.2017.148

Nazempour, R, & Darabi, H. (2023). Personalized Learning in Virtual Learning Environments Using Students’ Behavior Analysis.
Education Sciences. 2023; 13(5), 457. https://doi.org/10.3390/educsci13050457

Yan, L., Yin, C., Chen, H., Rong, W., Xiong, Z., & David, B. (2021). Learning Resource
Recommendation in E-Learning Systems Based on Online Learning Style. In: Qiu, H., Zhang, C.,
Fei, Z., Qiu, M., Kung, SY. (eds) Knowledge Science, Engineering and Management. KSEM 2021.
Lecture Notes in Computer Science, 12817. Springer, Cham. https://doi.org/10.1007/978-3-030-82153-1_31
}
\seealso{
\code{\link[=dataset_VLE_activity]{dataset_VLE_activity()}} for obtaining the VLE data set needed for input data
}
