% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/persp.loca.p.R
\name{persp.loca.p}
\alias{persp.loca.p}
\title{Plots of the min-sum objective function}
\usage{
\method{persp}{loca.p}(
  x,
  lp = numeric(0),
  xmin = min(x@x),
  xmax = max(x@x),
  ymin = min(x@y),
  ymax = max(x@y),
  n = 10,
  ticktype = "detailed",
  ...
)
}
\arguments{
\item{x}{The loca.p object to compute the objective.}

\item{lp}{If given, then \eqn{l_p} norm will be used instead of the Euclidean norm.}

\item{xmin}{The minimum value for x axis.}

\item{xmax}{The maximum value for x axis.}

\item{ymin}{The minimum value for y axis.}

\item{ymax}{The maximum value for y axis.}

\item{n}{The number of divisions for grid.}

\item{ticktype}{parameter to pass to low level function persp}

\item{\ldots}{Other options.}
}
\value{
A plot a 3D plot or min-sum function.
}
\description{
\code{persp} provides a graphical representations of min-sum function (\code{distsum}).
}
\details{
If \eqn{p<1} then \eqn{l_p} is not a norm, so only \eqn{p>=1} are valid values.
}
\examples{
# A new unweighted loca.p object
loca <- loca.p(x = c(-1, 1, 1, -1), y = c(-1, -1, 1, 1))

# The 3D graphics
persp(loca)

}
\seealso{
See also \code{\link{orloca-package}}, \code{\link{plot.loca.p}} and \code{\link{loca.p}}.
}
\keyword{classes}
\keyword{hplot}
