% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ocm.methods.R
\name{get_gfun}
\alias{get_gfun}
\alias{get_gfun.ocm}
\title{Estimated g function for a Fitted Model Object}
\usage{
get_gfun(object, ...)

\method{get_gfun}{ocm}(object, ...)
}
\arguments{
\item{object}{an \code{ocm} object}

\item{...}{further arguments to be passed to methods}
}
\value{
a dataframe containing four columns: the values of the score v, the estimated g function and the 95\%CIs

\code{NULL}
}
\description{
Calculates the estimated g function for a fitted \code{ocm} object
}
\examples{
\dontrun{
fit.overall  <- ocm(overall  ~ cycleno + age + bsa + treatment, data=ANZ0001.sub, scale=c(0,100))
get_gfun(fit.overall)
}
}
\seealso{
\code{\link{ocm}}
}
\author{
Maurizio Manuguerra, Gillian Heller
}
