% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{calldelta}
\alias{calldelta}
\title{Call Delta}
\usage{
calldelta(s, x, sigma, t, r, d = 0)
}
\arguments{
\item{s}{Spot price of the underlying asset}

\item{x}{Strike price of the option}

\item{sigma}{Implied volatility of the underlying asset price, defined as the annualized standard deviation of the asset returns}

\item{t}{Time to maturity in years}

\item{r}{Annual continuously-compounded risk-free rate, use the function r.cont}

\item{d}{Annual continuously-compounded dividend yield, use the function r.cont}
}
\value{
Returns the call delta
}
\description{
Calculates the delta of the European- style call option
}
\details{
The delta of an option can be defined as the rate of change of the option value given a $1 change in the underlying asset price.
}
\examples{
calldelta(100, 100, 0.20, (45/365), 0.02, 0.02)
}
