% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{toJSON}
\alias{toJSON}
\alias{toJSON,Process-method}
\alias{toJSON,Graph-method}
\title{Wrapper for toJSON}
\usage{
\S4method{toJSON}{Process}(
  x,
  dataframe = c("rows", "columns", "values"),
  matrix = c("rowmajor", "columnmajor"),
  Date = c("ISO8601", "epoch"),
  POSIXt = c("string", "ISO8601", "epoch", "mongo"),
  factor = c("string", "integer"),
  complex = c("string", "list"),
  raw = c("base64", "hex", "mongo", "int", "js"),
  null = c("list", "null"),
  na = c("null", "string"),
  auto_unbox = FALSE,
  digits = 4,
  pretty = FALSE,
  force = FALSE,
  ...
)

\S4method{toJSON}{Graph}(
  x,
  dataframe = c("rows", "columns", "values"),
  matrix = c("rowmajor", "columnmajor"),
  Date = c("ISO8601", "epoch"),
  POSIXt = c("string", "ISO8601", "epoch", "mongo"),
  factor = c("string", "integer"),
  complex = c("string", "list"),
  raw = c("base64", "hex", "mongo", "int", "js"),
  null = c("list", "null"),
  na = c("null", "string"),
  auto_unbox = FALSE,
  digits = 4,
  pretty = FALSE,
  force = FALSE,
  ...
)
}
\arguments{
\item{x}{a Process or Graph object}

\item{dataframe}{how to encode data.frame objects: must be one of 'rows', 'columns' or 'values'}

\item{matrix}{how to encode matrices and higher dimensional arrays: must be one of 'rowmajor' or 'columnmajor'.}

\item{Date}{how to encode Date objects: must be one of 'ISO8601' or 'epoch'}

\item{POSIXt}{how to encode POSIXt (datetime) objects: must be one of 'string', 'ISO8601', 'epoch' or 'mongo'}

\item{factor}{how to encode factor objects: must be one of 'string' or 'integer'}

\item{complex}{how to encode complex numbers: must be one of 'string' or 'list'}

\item{raw}{how to encode raw objects: must be one of 'base64', 'hex' or 'mongo'}

\item{null}{how to encode NULL values within a list: must be one of 'null' or 'list'}

\item{na}{how to print NA values: must be one of 'null' or 'string'. Defaults are class specific}

\item{auto_unbox}{automatically \code{\link[jsonlite:unbox]{unbox()}} all atomic vectors of length 1. It is usually safer to avoid this and instead use the \code{\link[jsonlite:unbox]{unbox()}} function to unbox individual elements.
An exception is that objects of class \code{AsIs} (i.e. wrapped in \code{\link[=I]{I()}}) are not automatically unboxed. This is a way to mark single values as length-1 arrays.}

\item{digits}{max number of decimal digits to print for numeric values. Use \code{\link[=I]{I()}} to specify significant digits. Use \code{NA} for max precision.}

\item{pretty}{adds indentation whitespace to JSON output. Can be TRUE/FALSE or a number specifying the number of spaces to indent. See \code{\link[jsonlite:prettify]{prettify()}}}

\item{force}{unclass/skip objects of classes with no defined JSON mapping}

\item{...}{additional parameters that are passed to jsonlite::toJSON}
}
\value{
JSON string of the process as a character string
}
\description{
This function is intended to have a preconfigured toJSON function
to allow a user to visualize a process or graph in JSON. The JSON representation
of a process is the same as it will be sent to the back-end.
}
\examples{
\dontrun{
# node is a defined process node
process = as(node, "Process")
toJSON(process)

graph = process$getProcessGraph()
toJSON(graph)
}
}
