/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import java.io.File;
import java.io.IOException;
import opennlp.maxent.Event;
import opennlp.maxent.FileEventStream;
import opennlp.maxent.GIS;
import opennlp.maxent.GISModel;
import opennlp.maxent.OnePassRealValueDataIndexer;
import opennlp.maxent.io.SuffixSensitiveGISModelWriter;

public class RealValueFileEventStream
extends FileEventStream {
    public RealValueFileEventStream(String fileName) throws IOException {
        super(fileName);
    }

    public RealValueFileEventStream(File file) throws IOException {
        super(file);
    }

    public static float[] parseContexts(String[] contexts) {
        boolean hasRealValue = false;
        float[] values = new float[contexts.length];
        int ci = 0;
        while (ci < contexts.length) {
            int ei = contexts[ci].lastIndexOf("=");
            if (ei > 0 && ei + 1 < contexts[ci].length()) {
                boolean gotReal = true;
                try {
                    values[ci] = Float.parseFloat(contexts[ci].substring(ei + 1));
                }
                catch (NumberFormatException e) {
                    gotReal = false;
                    System.err.println("Unable to determine value in context:" + contexts[ci]);
                    values[ci] = 1.0f;
                }
                if (gotReal) {
                    if (values[ci] < 0.0f) {
                        throw new RuntimeException("Negitive values are not allowed: " + contexts[ci]);
                    }
                    contexts[ci] = contexts[ci].substring(0, ei);
                    hasRealValue = true;
                }
            } else {
                values[ci] = 1.0f;
            }
            ++ci;
        }
        if (!hasRealValue) {
            values = null;
        }
        return values;
    }

    public Event nextEvent() {
        int si = this.line.indexOf(32);
        String outcome = this.line.substring(0, si);
        String[] contexts = this.line.substring(si + 1).split(" ");
        float[] values = RealValueFileEventStream.parseContexts(contexts);
        return new Event(outcome, contexts, values);
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Usage: RealValueFileEventStream eventfile [iterations cutoff]");
            System.exit(1);
        }
        int ai = 0;
        String eventFile = args[ai++];
        RealValueFileEventStream es = new RealValueFileEventStream(eventFile);
        int iterations = 100;
        int cutoff = 5;
        if (ai < args.length) {
            iterations = Integer.parseInt(args[ai++]);
            cutoff = Integer.parseInt(args[ai++]);
        }
        GISModel model = GIS.trainModel(iterations, new OnePassRealValueDataIndexer(es, cutoff));
        new SuffixSensitiveGISModelWriter(model, new File(String.valueOf(eventFile) + ".bin.gz")).persist();
    }
}

