/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.chunker;

import java.util.ArrayList;
import opennlp.maxent.DataStream;
import opennlp.maxent.Event;
import opennlp.maxent.EventStream;
import opennlp.tools.chunker.ChunkerContextGenerator;
import opennlp.tools.chunker.DefaultChunkerContextGenerator;

public class ChunkerEventStream
implements EventStream {
    private ChunkerContextGenerator cg;
    private DataStream data;
    private Event[] events;
    private int ei;

    public ChunkerEventStream(DataStream d) {
        this(d, new DefaultChunkerContextGenerator());
    }

    public ChunkerEventStream(DataStream d, ChunkerContextGenerator cg) {
        this.cg = cg;
        this.data = d;
        this.ei = 0;
        if (d.hasNext()) {
            this.addNewEvents();
        } else {
            this.events = new Event[0];
        }
    }

    public Event nextEvent() {
        if (this.ei == this.events.length) {
            this.addNewEvents();
            this.ei = 0;
        }
        return this.events[this.ei++];
    }

    public boolean hasNext() {
        return this.ei < this.events.length || this.data.hasNext();
    }

    private void addNewEvents() {
        ArrayList<String> toks = new ArrayList<String>();
        ArrayList<String> tags = new ArrayList<String>();
        ArrayList<String> preds = new ArrayList<String>();
        String line = (String)this.data.nextToken();
        while (line != null && !line.equals("")) {
            String[] parts = line.split(" ");
            if (parts.length != 3) {
                System.err.println("Skipping corrupt line: " + line);
            } else {
                toks.add(parts[0]);
                tags.add(parts[1]);
                preds.add(parts[2]);
            }
            line = (String)this.data.nextToken();
        }
        this.events = new Event[toks.size()];
        Object[] toksArray = toks.toArray();
        String[] tagsArray = tags.toArray(new String[tags.size()]);
        String[] predsArray = preds.toArray(new String[preds.size()]);
        int el = this.events.length;
        for (int ei = 0; ei < el; ++ei) {
            this.events[ei] = new Event((String)preds.get(ei), this.cg.getContext(ei, toksArray, tagsArray, predsArray));
        }
    }
}

