/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CountedSet
implements Set {
    private Map cset;
    private static Integer ONE = new Integer(1);

    public CountedSet() {
        this.cset = new HashMap();
    }

    public CountedSet(int size) {
        this.cset = new HashMap(size);
    }

    public boolean add(Object o) {
        Integer count = (Integer)this.cset.get(o);
        if (count == null) {
            this.cset.put(o, ONE);
            return true;
        }
        this.cset.put(o, new Integer(count + 1));
        return false;
    }

    public void subtract(Object o) {
        Integer count = (Integer)this.cset.get(o);
        if (count != null) {
            int c = count - 1;
            if (c == 0) {
                this.cset.remove(o);
            } else {
                this.cset.put(o, new Integer(c));
            }
        }
    }

    public void setCount(Object o, int c) {
        this.cset.put(o, new Integer(c));
    }

    public int getCount(Object o) {
        Integer count = (Integer)this.cset.get(o);
        if (count == null) {
            return 0;
        }
        return count;
    }

    public void write(String fileName, int countCutoff) {
        this.write(fileName, countCutoff, " ");
    }

    public void write(String fileName, int countCutoff, String delim) {
        this.write(fileName, countCutoff, delim, null);
    }

    public void write(String fileName, int countCutoff, String delim, String encoding) {
        PrintWriter out = null;
        try {
            out = encoding != null ? new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), encoding)) : new PrintWriter(new FileWriter(fileName));
            for (Object key : this.cset.keySet()) {
                int count = this.getCount(key);
                if (count < countCutoff) continue;
                out.println(count + delim + key);
            }
            out.close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public boolean addAll(Collection c) {
        boolean changed = false;
        Iterator ci = c.iterator();
        while (ci.hasNext()) {
            changed = changed || this.add(ci.next());
        }
        return changed;
    }

    public void clear() {
        this.cset.clear();
    }

    public boolean contains(Object o) {
        return this.cset.keySet().contains(o);
    }

    public boolean containsAll(Collection c) {
        return this.cset.keySet().containsAll(c);
    }

    public boolean isEmpty() {
        return this.cset.isEmpty();
    }

    public Iterator iterator() {
        return this.cset.keySet().iterator();
    }

    public boolean remove(Object o) {
        return this.cset.remove(o) != null;
    }

    public boolean removeAll(Collection c) {
        boolean changed = false;
        Iterator ki = this.cset.keySet().iterator();
        while (ki.hasNext()) {
            changed = changed || this.cset.remove(ki.next()) != null;
        }
        return changed;
    }

    public boolean retainAll(Collection c) {
        boolean changed = false;
        for (Object key : this.cset.keySet()) {
            if (c.contains(key)) continue;
            this.cset.remove(key);
            changed = true;
        }
        return changed;
    }

    public int size() {
        return this.cset.size();
    }

    public Object[] toArray() {
        return this.cset.keySet().toArray();
    }

    public Object[] toArray(Object[] arg0) {
        return this.cset.keySet().toArray(arg0);
    }
}

