% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.taxonomy.r
\name{opal.terms}
\alias{opal.terms}
\title{Get the terms of a vocabulary}
\usage{
opal.terms(opal, taxonomy, vocabulary, locale = "en", df = TRUE)
}
\arguments{
\item{opal}{Opal object.}

\item{taxonomy}{Name of the taxonomy}

\item{vocabulary}{Name of the vocabulary in the taxonomy}

\item{locale}{The language for labels (default is "en").}

\item{df}{Return a data.frame (default is TRUE)}
}
\description{
Get all the terms of a vocabulary. The term describes the value of a variable annotation.
}
\examples{
\donttest{
o <- opal.login('administrator','password','https://opal-demo.obiba.org')
opal.terms(o, 'Mlstr_area', 'Lifestyle_behaviours')
opal.logout(o)
}
}
\seealso{
Other taxonomy functions: 
\code{\link{opal.taxonomies}()},
\code{\link{opal.taxonomy}()},
\code{\link{opal.vocabularies}()},
\code{\link{opal.vocabulary}()}
}
\concept{taxonomy functions}
