% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transPk.R
\name{pkTrans}
\alias{pkTrans}
\title{Change the transformation type for PK models}
\usage{
pkTrans(
  ui,
  type = c("k", "k21", "vss", "aob", "alpha"),
  k13 = "k13",
  k31 = "k31",
  k12 = "k12",
  k21 = "k21",
  kel = "kel",
  vc = "vc",
  cl = "cl",
  vp = "vp",
  q = "q",
  vp2 = "vp2",
  q2 = "q2",
  vss = "vss",
  aob = "aob",
  alpha = "alpha",
  beta = "beta",
  gam = "gam",
  A = "A",
  B = "B",
  C = "C",
  s = "s",
  p = "p",
  tmp = "tmp",
  beforeCmt = c("depot", "central")
)
}
\arguments{
\item{ui}{A model in terms of Clearance}

\item{type}{the type of PK transformation to make:

 - \code{"k"}: Change to rate constants (kel, k12, k21, k13, k31)

 - \code{"vss"}: Change to volume of distribution at steady state (cl, vc, q, vss)

 - \code{"aob"}: Change to A/B ratio (aob, alpha, beta, vc)

 - \code{"k21"}: Change to k21 constant (k21, alpha, beta, vc) or (k21, k31, alpha, beta, gam, vc)

- \code{"alpha"}: Change to macro constants  (alpha, beta, gam, A, B, C, vc)}

\item{k13}{name of rate constant from central to periph2}

\item{k31}{name of rate constant from periph2 to central}

\item{k12}{name of rate constant from central to periph1}

\item{k21}{name of rate constant from periph1 to central}

\item{kel}{name of elimination rate constant}

\item{vc}{name of central compartment volume}

\item{cl}{name of clearance}

\item{vp}{name of volume of periph1}

\item{q}{name of intercompartmental clearance between central and
periph1}

\item{vp2}{name of volume of periph2}

\item{q2}{name of intercompartmental clearance between central and
periph2}

\item{vss}{name of volume of distribution at steady state}

\item{aob}{A/B ratio}

\item{alpha}{macro constant name for first exponential decay term}

\item{beta}{macro constant name for second exponential decay term}

\item{gam}{macro constant name for third exponential decay term}

\item{A}{macro coefficient for the first exponential decay term
(corresponds with alpha)}

\item{B}{macro coefficient for the second exponential decay term
(corresponds with beta)}

\item{C}{macro coefficient for the third exponential decay term
(corresponds with gam)}

\item{s}{sum constant name for the k12 three compartment}

\item{p}{product constant name for the k12 three compartment}

\item{tmp}{name of temporary variable for the three compartment
with `A`, `B`, `C`, `alpha`, `beta` and `gam`.}

\item{beforeCmt}{if the model is compartmental you can specify the
preferred names where the estimates and extra lines are added
before}
}
\value{
ui with no PK parameters estimated
}
\description{
Change the transformation type for PK models
}
\examples{

\donttest{
# Three compartment model translations

readModelDb("PK_3cmt_des") |>
  pkTrans("k")

readModelDb("PK_3cmt_des") |>
  pkTrans("k21")

readModelDb("PK_3cmt_des") |>
  pkTrans("alpha")

# The most types of transformations are
# available for 2 compartment models

readModelDb("PK_2cmt_des") |>
  pkTrans("k")

readModelDb("PK_2cmt_des") |>
  pkTrans("vss")

readModelDb("PK_2cmt_des") |>
  pkTrans("aob")

readModelDb("PK_2cmt_des") |>
  pkTrans("k21")

readModelDb("PK_2cmt_des") |>
  pkTrans("alpha")

# One compartment transformations are also available:

readModelDb("PK_1cmt_des") |>
  pkTrans("k")

readModelDb("PK_1cmt_des") |>
  pkTrans("alpha")

# also works without depot:

readModelDb("PK_3cmt_des") |>
  removeDepot() |>
  pkTrans("k")

}
}
\author{
Matthew L. Fidler
}
