% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preProcessZeroOmega.R
\name{rmEta}
\alias{rmEta}
\title{Remove an eta from the model}
\usage{
rmEta(ui, eta)
}
\arguments{
\item{ui}{rxode2 user interface}

\item{eta}{eta to remove}
}
\value{
ui model with eta removed
}
\description{
Remove an eta from the model
}
\examples{

mod <- function ()  {
 description <- "One compartment PK model with linear clearance"
 ini({
   lka <- 0.45
   lcl <- 1
   lvc <- 3.45
    propSd <- c(0, 0.5)
    etaKa ~ 0.1
  })
 model({
   ka <- exp(lka + etaKa)
   cl <- exp(lcl)
   vc <- exp(lvc)
   Cc <- linCmt()
   Cc ~ prop(propSd)
 })
}

mod \%>\% rmEta("etaKa")

# This can also remove more than one eta

mod <- function ()  {
 description <- "One compartment PK model with linear clearance"
 ini({
   lka <- 0.45
   lcl <- 1
   lvc <- 3.45
   propSd <- c(0, 0.5)
   etaKa ~ 0.1
   etaCl ~ 0.2
   etaVc ~ 0.3
  })
 model({
   ka <- exp(lka + etaKa)
   cl <- exp(lcl + etaCl)
   vc <- exp(lvc + etaVc)
   Cc <- linCmt()
   Cc ~ prop(propSd)
 })
}

mod \%>\% rmEta(c("etaKa", "etaCl"))

}
\author{
Matthew L. Fidler
}
