% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/mutators.R
\docType{methods}
\name{totals}
\alias{totals}
\alias{totals-method}
\alias{totals<-}
\alias{totals,CompositionMatrix-method}
\alias{totals,LogRatio-method}
\alias{totals<-,CompositionMatrix-method}
\title{Row Sums}
\usage{
totals(object)

totals(object) <- value

\S4method{totals}{CompositionMatrix}(object)

\S4method{totals}{LogRatio}(object)

\S4method{totals}{CompositionMatrix}(object) <- value
}
\arguments{
\item{object}{An object from which to get or set \code{totals}.}

\item{value}{A possible value for the \code{totals} of \code{x}.}
}
\value{
\itemize{
\item \code{totals() <- value} returns an object of the same sort as \code{x} with the new
row sums assigned.
\item \code{totals()} returns the row sums of \code{x}.
}
}
\description{
Retrieves or defines the row sums (before \link[=closure]{closure}).
}
\examples{
## Create a count matrix
A1 <- matrix(data = sample(1:100, 100, TRUE), nrow = 20)

## Coerce to compositions
B <- as_composition(A1)

## Row sums are internally stored before coercing to relative frequencies
totals(B)

## This allows to restore the source data
A2 <- as_amounts(B)

## Coerce to a data.frame
X <- as.data.frame(B)
head(X)
}
\seealso{
Other mutators: 
\code{\link{as.data.frame}()},
\code{\link{mutators}}
}
\author{
N. Frerebeau
}
\concept{mutators}
