% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_publications.R
\name{get_publications.default}
\alias{get_publications.default}
\title{Get publication information from Neotoma}
\usage{
\method{get_publications}{default}(...)
}
\arguments{
\item{...}{\code{publicationid}
The unique numeric identifier associated with a publication in Neotoma.
\code{datasetid}
A unique identifier for a Neotoma dataset that is associated
with a publication.
\code{familyname} The full or partial last name for an individual author.
\code{pubtype} The publication type, from \code{get_tables("publicationtypes")}.
\code{year} The year the publication was released.
\code{search} A plain text search string used to search the citation.}
}
\value{
\code{publications} object
}
\description{
Get publication information from Neotoma
}
\examples{
\donttest{
# How old are the papers in Neotoma that include the term "mammut"?
mammoth_papers <- get_publications(search="mammut") \%>\%
  as.data.frame()
hist(as.numeric(mammoth_papers$year))
}
}
